Rem
Rem $Header: rdbms/admin/backport_files/bug_31942136_apply.sql ramekuma_blr_backport_33027539_19.11.0.0.210420dbru/2 2021/08/23 19:19:21 ramekuma Exp $
Rem
Rem bug_31942136_apply.sql
Rem
Rem Copyright (c) 2020, 2021, Oracle and/or its affiliates. 
Rem
Rem    NAME
Rem      bug_31942136_apply.sql - Upgrade action for bug-31942136
Rem
Rem    DESCRIPTION
Rem      This script performs the upgrade actions for the backport of
Rem      bug 31942136.  It is run by datapatch to apply the patch to
Rem      existing databases and is also run by upgrades from prior
Rem      releases to the patched Oracle Home.
Rem
Rem    NOTES
Rem      Add a guard column if needed and allocate a guard ID for a primary key
Rem    on a MODV column
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: rdbms/admin/backport_files/bug_31942136_apply.sql
Rem    SQL_SHIPPED_FILE: rdbms/admin/backport_files/bug_31942136_apply.sql
Rem    SQL_PHASE: RDBMS_PREAPPLY
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ramekuma    08/23/21 - Backport
Rem                           apfwkr_ci_backport_31942136_19.0.0.0.0dbru from
Rem                           st_rdbms_19
Rem    ramekuma    11/30/20 - Upgrade action for bug-31942136
Rem    ramekuma    11/30/20 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

Rem *************************************************************************
Rem BEGIN Changes for Bug 31942136
Rem *************************************************************************

DECLARE
  ddlstr  varchar2(32767);

  CURSOR  pkey_cons_csr IS
   select u.name user_name, o.name tbl_name, cd.enabled
   from cdef$ cd, ccol$ cc, col$ cl, obj$ o, user$ u
   where cl.obj# = cd.obj#
     and cc.intcol# = cl.intcol#
     and cd.con# = cc.con#
     and cd.type# = 2
     and bitand(cl.property, 1073741824) = 1073741824
     and cd.obj# = o.obj#
     and o.owner# = u.user#
     and not exists (select * from recyclebin$ rb where rb.obj# = cd.obj#)
     order by 1, 2;
   
BEGIN

  FOR pkey_rec in pkey_cons_csr
  LOOP
    IF pkey_rec.enabled is NULL
    THEN
      ddlstr := 'ALTER TABLE ' || 
                DBMS_ASSERT.ENQUOTE_NAME(pkey_rec.user_name, false) || '.' || 
                DBMS_ASSERT.ENQUOTE_NAME(pkey_rec.tbl_name, false) || 
                ' DISABLE PRIMARY KEY';
    ELSE
      ddlstr := 'ALTER TABLE ' || 
                dbms_assert.enquote_name(pkey_rec.user_name, false) || '.' || 
                dbms_assert.enquote_name(pkey_rec.tbl_name, false) || 
                ' ENABLE PRIMARY KEY';
    END IF;

    EXECUTE IMMEDIATE ddlstr;
  END LOOP;
EXCEPTION
  WHEN OTHERS THEN
   NULL;
END;
/

Rem *************************************************************************
Rem END Changes for Bug 31942136
Rem *************************************************************************

-- Record the fix for bug 31942136 into registry$backports
INSERT /*+IGNORE_ROW_ON_DUPKEY_INDEX(registry$backports, registry_backports_pk)*/
INTO sys.registry$backports (version_full, bugno)
VALUES ((SELECT version_full FROM sys.v$instance),
        31942136);
COMMIT;

@?/rdbms/admin/sqlsessend.sql
 
