SET SERVEROUTPUT ON

REM Apply script for patch 33027539/24390909
DEFINE logfiledir = &1

COLUMN sqlpatch_logfile NEW_VALUE full_logfile

SELECT '&logfiledir' || '33027539_apply_' ||
       CASE WHEN (sys_context('userenv', 'cdb_name') IS NULL) 
            THEN name
            ELSE name || '_' || replace(sys_context('userenv', 'con_name'), '$')
             END || TO_CHAR(systimestamp, '_YYYYMonDD_HH24_MI_SS',
             'NLS_DATE_LANGUAGE=AMERICAN') ||'.log' AS sqlpatch_logfile
  FROM v$database;

SPOOL &full_logfile

SET PAGESIZE 0
SELECT 'Starting apply for patch 33027539/24390909 on ' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

BEGIN
    dbms_sqlpatch.patch_initialize(p_patch_id      => 33027539,
                                   p_patch_uid     => 24390909,
                                   p_logfile       => '&full_logfile');
END;
/


COLUMN install_file NEW_VALUE sql_script


ALTER SESSION SET CURRENT_SCHEMA = SYS;

SET PAGESIZE 0
SELECT 'Calling rdbms/admin/backport_files/bug_31942136_apply.sql on ' || SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

PROMPT IGNORABLE ERRORS: NONE

SELECT dbms_sqlpatch.install_file('rdbms/admin/backport_files/bug_31942136_apply.sql') AS install_file
  FROM dual;
@@&sql_script



BEGIN dbms_sqlpatch.patch_finalize; END;
/

SET PAGESIZE 0
SELECT 'Finished apply for patch 33027539/24390909 on' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

SPOOL off

