<?xml version="1.0"?>
<!--

 Copyright (c) 2000, 2021, Oracle and/or its affiliates. 

NAME
    kuconstr.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of muapi_constraint_t ADTs
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED        MM/DD/YY
    apfwkr      03/10/21 - Backport
                           apfwkr_blr_backport_30978304_19.10.0.0.210119dbru
                           from st_rdbms_19.10.0.0.0dbru
    apfwkr      12/18/20 - Backport
                           apfwkr_blr_backport_30978304_19.9.0.0.201020dbru
                           from st_rdbms_19.9.0.0.0dbru
    apfwkr      09/02/20 - Backport
                           apfwkr_blr_backport_30978304_19.8.0.0.200714dbru
                           from st_rdbms_19.8.0.0.0dbru
    apfwkr      06/29/20 - Backport
                           apfwkr_blr_backport_30978304_19.7.0.0.200414dbru
                           from st_rdbms_19.7.0.0.0dbru
    apfwkr      05/27/20 - Backport sdavidso_bug-30978304 from main
    sdavidso    05/18/20 - bug-30978304 assure creation of indexes by
                           constraints
    jjanosik    04/13/18 - Bug 27067886: fix constraint name size
    tbhukya     03/27/18 - Bug 27761685: Generate PK index in PKOID table ddl
                           if index was created by constraint o.w. generate
                           CREATE INDEX, ALTER TABLE enable PK ddls along with
                           table DDL.
    rapayne     03/10/18 - Bug 27669276: add support for dwcs_enable_constraints.
    tbhukya     02/02/18 - RTI 20936979: For online redef use using index 
                           storage syntax
    tbhukya     10/10/17 - Bug 20217704: Use existing index name in constraint if
                           index is not created by constraint
    tbhukya     11/13/17 - Bug 26739164: Use index name when index was not created
                           by constraint for parent table's primary key 
    rapayne     10/10/17 - Bug 26895793:fix RELY when DWCS_CVT_CONSTRAINTS is set.
    rapayne     09/22/17 - Bug 26878794: Fix NOT NULL constraints.
    jjanosik    08/17/17 - Bug 26617473 handle departitioning
    rapayne     08/13/17 - DWCS: changes to accommodate Data Warehouse Cloud env
    sdavidso    02/14/17 - bug25440009 handle user name with apostrophe
    sdavidso    11/01/16 - bug24702971 for sharding, use constraints_as_alter
    sdavidso    06/03/16 - bug23262571 avoid ORA-054 for move chunk
    sogugupt    11/26/15 - Bug 22229581: Replace intcol_num to segcol_num
    sdavidso    11/17/15 - bug21869037 chunk move w/subpartitions
    sdavidso    07/27/15 - bug21501564: P2T unique name for NOT NULL constr
    sdavidso    02/06/15 - proj 56220 - partition transportable
    tbhukya     01/05/15 - Bug 20319428: Declare referred params and import
                           xsl files for referred templates
    tbhukya     11/15/13 - Bug 17803321: Use index in PK and Unique constraints
    bwright     08/15/13 - Bug 17312600: Remove hard tabs from DP src code
    lbarton     04/03/13 - bug 11769592: index name != constraint name
    mjangir     10/09/12 - bug 13419329: local partitioned index
    sdavidso    02/26/12 - bug13714302: name index for add PK constraint
    sdavidso    08/09/11 - FORCE_UNIQUE transform support
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    emagrath    02/10/04 - Transportable OID/SETID constraints/indexes
    emagrath    06/06/03 - Correct index info for constraints
    emagrath    05/20/03 - Revamp constraint processing
    htseng      02/11/03 - fix bug 2795373 handle constraint NULL value
    lbarton     08/02/02 - transportable export
    htseng      05/29/02 - add supplemental log support.
    emagrath    01/31/02 - Complete support for REF constraints
    dgagne      06/28/01 - fix bug 1757298
    lbarton     01/22/01 - bugfix: foreign key constr on objtab refs
    lbarton     01/12/01 - fix comment
    lbarton     01/10/01 - nested table referential constraints
    lbarton     10/13/00 - bugfixes: not null/foreign key on adt/ref, etc.
    gclaborn    11/03/00 - change name
    lbarton     10/05/00 - more bugfixes
    lbarton     09/25/00 - bugfix: temporary tables
    lbarton     06/23/00 - RELY
    lbarton     06/12/00 - SEGMENT_ATTRIBUTES support
    lbarton     05/17/00 - Params for new API
    lbarton     03/17/00 - Multinested collections
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Needed for temaplates ColNameOrAttr, DoParse, DoTerminator -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Param ONLINE_REDEF is set for cosntraint in online redefinition to retain 
      old syntax.
      When this param is set then online redifition generates constraint as 
      "ALTER TABLE <tname> ADD CONSTRAINT <cname> PRIMARY KEY/UNIQUE ..
             USING INDEX .. STORAGE (...)"
      When not set then syntax is
      "ALTER TABLE <tname> ADD CONSTRAINT <cname> PRIMARY KEY/UNIQUE ..
             USING INDEX (CREATE UNIQUE INDEX ..)"
      Usage of second syntax causes failure in 
      dbms_redefinition.copy_table_dependents() for constraint.
      Due to this reason first syntax is used for online redefinition.
  -->
 <xsl:param name="ONLINE_REDEF" select="''"/>
 <xsl:param name="INDEX_BY_NAME">0</xsl:param>
 <xsl:param name="CONSTR_INDEX_FIDELITY">0</xsl:param>
 <xsl:param name="FORCE_UNIQUE">0</xsl:param>
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="PARTITION_NAME" select="''"/>
 <xsl:param name="SUBPARTITION_NAME" select="''"/>
 <!-- UNIQUE_NAME is set to a string for the sharding MOVE CHUNK operation-->
 <xsl:param name="UNIQUE_NAME" select="''"/>
 <!-- Templates -->
 <xsl:template name="DoConstraint">
  <xsl:param name="TAB_CONSTRAINT">0</xsl:param>
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="ConstraintNode" select="''"/>
  <xsl:param name="P2T_Node" select="''"/>
  <xsl:param name="ColListNode" select="''"/>
  <xsl:param name="HasPkOID">0</xsl:param>
  <xsl:param name="InColList" select="''"/>
  <!-- *******************************************************************
Template: DoConstraint
Parameters:
  TAB_CONSTRAINT:       1 = this is a table constraint
                        other = this is a column constraint
  Property:             value of TABLE_T/PROPERTY
  ConstraintNode:       the CON node
  ColListNode:          the table column list
  
   'FLAGS' has the following definition in sql.bsq:
  defer         number,                     /* 0x01 constraint is deferrable */
                                              /* 0x02 constraint is deferred */
                                /* 0x04 constraint has been system validated */
                                 /* 0x08 constraint name is system generated */
                       /* 0x10 constraint is BAD, depends on current century */
                           /* 0x20, optimizer should RELY on this constraint */
******************************************************************** -->
  <!-- if not system-generated name, emit constraint name -->
  <xsl:variable name="FullName">
   <xsl:variable name="FName">
    <xsl:if test="string-length($UNIQUE_NAME) > 0">
     <xsl:text>KU$_</xsl:text>
     <xsl:value-of select="$UNIQUE_NAME"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="CON_NUM"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="ancestor::TABLE_T/TABPART/PHYPART_NUM"/>
     <xsl:value-of select="ancestor::TABLE_T/SUBPART/PHYPART_NUM"/>
     <xsl:text>_</xsl:text>
    </xsl:if>
    <!-- if we are not departitioning get the name -->
    <xsl:if test="not($PARTITION_NAME) and not($SUBPARTITION_NAME)">
     <xsl:value-of select="NAME"/>
    </xsl:if>
   </xsl:variable>
   <xsl:value-of select="substring($FName,1,128)"/>
  </xsl:variable>
  <xsl:choose>
   <xsl:when test="CONTYPE='12'">
    <xsl:text> SUPPLEMENTAL LOG GROUP "</xsl:text>
    <xsl:value-of select="$FullName"/>
    <xsl:text>"</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:choose>
     <!-- if there is an assoicated index for this constraint (only uk/pk) and the ADW 
           transform is enabled then we are going to rename the constraint with the 
           index name. This is done even for system generate constraint names.
-->
     <xsl:when test="$CONSTRAINT_NAME_FROM_INDEX=1 and ./IND/SCHEMA_OBJ and
             (CONTYPE='2' or CONTYPE='3')">
      <xsl:text> CONSTRAINT </xsl:text>
      <xsl:call-template name="QuoteObject">
       <xsl:with-param name="Object" select="./IND/SCHEMA_OBJ/NAME"/>
      </xsl:call-template>
     </xsl:when>
     <!-- is the constraint name system generated -->
     <xsl:when test="(FLAGS mod 16)>=8"/>
     <xsl:otherwise>
      <!-- Constraint clause is not valid for enabling PK in PkOID -->
      <xsl:if test="string-length($FullName)>0 and not ($HasPkOID=1 and $InColList=0)">
       <xsl:text> CONSTRAINT "</xsl:text>
       <xsl:value-of select="$FullName"/>
       <xsl:text>"</xsl:text>
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="CONTYPE='1'">
    <xsl:text> CHECK (</xsl:text>
    <xsl:value-of select="CONDITION"/>
    <xsl:text>)</xsl:text>
    <xsl:call-template name="DoFlags"/>
    <xsl:apply-templates select="ENABLED"/>
   </xsl:when>
   <xsl:when test="CONTYPE='12'">
    <xsl:text> (</xsl:text>
    <xsl:call-template name="DoConstraintColList">
     <xsl:with-param name="ConstraintColList" select="COL_LIST"/>
    </xsl:call-template>
    <xsl:text>)</xsl:text>
    <xsl:call-template name="DoFlags"/>
   </xsl:when>
   <xsl:when test="CONTYPE='2'">
    <xsl:text> PRIMARY KEY</xsl:text>
    <xsl:call-template name="DoPrimaryUnique">
     <xsl:with-param name="Property" select="$Property"/>
     <xsl:with-param name="HasPkOID" select="$HasPkOID"/>
     <xsl:with-param name="InColList" select="$InColList"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="CONTYPE='3'">
    <xsl:text> UNIQUE</xsl:text>
    <xsl:call-template name="DoPrimaryUnique">
     <xsl:with-param name="Property" select="$Property"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="CONTYPE='4'">
    <!-- Referential constraints -->
    <xsl:if test="$TAB_CONSTRAINT=1">
     <xsl:text> FOREIGN KEY (</xsl:text>
     <xsl:choose>
      <!-- A referential constraint on a REF whose referenced object table
             has an OID based on a PRIMARY KEY may specify multiple source
             columns (one for each 'exploded' col/attr of the potentially
             compound Primary key). The source col/attr names were 'corrected'
             to specify the actual REF item when the metadata was collected,
             however only 1 source column must be used in the constraint.
              Example:
                create type type1 as object (a1 number, a2 number);
                create table table1 of type1 (primary key(a1, a2))
                  object identifier primary key;
                create table table2 (c1 ref type1,
                   foreign key (c1) references table1);

               Foreign key source columns generated:
                 c1.a1, c1.a2
                each having column property  0x00200000 (2097152)
                    attribute column of a user-defined ref.
               Corrected columns names stored, respectively:
                 c1,    c1
          -->
      <xsl:when test="(SRC_COL_LIST/SRC_COL_LIST_ITEM/COL/PROPERTY mod 4194304)>=2097152">
       <xsl:call-template name="ColNameOrAttr">
        <xsl:with-param name="ColItem" select="SRC_COL_LIST/SRC_COL_LIST_ITEM/COL"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="DoConstraintColList">
        <xsl:with-param name="ConstraintColList" select="SRC_COL_LIST"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:text>)</xsl:text>
    </xsl:if>
    <!-- only for Table constraints -->
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;&#x9; </xsl:text>
    </xsl:if>
    <xsl:text> REFERENCES </xsl:text>
    <xsl:apply-templates select="SCHEMA_OBJ"/>
    <!-- A referential constraint on a REF whose referenced object table
             has an OID based on a PRIMARY KEY may specify multiple target
             columns (one for each col/attr of the potentially compound Primary
             key - see above example).  Do not emit the target col/attr list
             if the ref attribute property exists for the [first] source col
             (unneeded since it references the Primary key).
          -->
    <xsl:if test="(SRC_COL_LIST/SRC_COL_LIST_ITEM/COL/PROPERTY mod 4194304)&lt;2097152">
     <xsl:text>(</xsl:text>
     <xsl:call-template name="DoConstraintColList">
      <xsl:with-param name="ConstraintColList" select="TGT_COL_LIST"/>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:if>
    <xsl:apply-templates select="REFACT"/>
    <xsl:call-template name="DoFlags"/>
    <xsl:apply-templates select="ENABLED"/>
   </xsl:when>
   <!-- Referential constraints -->
   <xsl:when test="CONTYPE='7' or CONTYPE='11'">
    <xsl:text> NOT NULL</xsl:text>
    <xsl:call-template name="DoFlags"/>
    <xsl:apply-templates select="ENABLED"/>
   </xsl:when>
   <xsl:when test="CONTYPE='14'">
    <xsl:text> SUPPLEMENTAL LOG DATA (PRIMARY KEY) COLUMNS</xsl:text>
   </xsl:when>
   <xsl:when test="CONTYPE='15'">
    <xsl:text> SUPPLEMENTAL LOG DATA (UNIQUE INDEX) COLUMNS</xsl:text>
   </xsl:when>
   <xsl:when test="CONTYPE='16'">
    <xsl:text> SUPPLEMENTAL LOG DATA (FOREIGN KEY) COLUMNS</xsl:text>
   </xsl:when>
   <xsl:when test="CONTYPE='17'">
    <xsl:text> SUPPLEMENTAL LOG DATA (ALL) COLUMNS</xsl:text>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoFlags">
  <!-- *******************************************************************
Template: DoFlags
Current node: CONx_LIST_ITEM
******************************************************************** -->
  <xsl:if test="(FLAGS mod 2)=1">
   <xsl:text> DEFERRABLE</xsl:text>
  </xsl:if>
  <xsl:if test="(FLAGS mod 4)>=2">
   <xsl:text> INITIALLY DEFERRED</xsl:text>
  </xsl:if>
  <!-- force RELY when in Data Warehouse Cloud Service env when: 
       - uk/pk/fk
       - and NOT (disabled without rely)
  -->
  <xsl:if test="(FLAGS mod 64)>=32 or 
                     ($DWCS_CVT_CONSTRAINTS = 1 and ENABLED != '0' and 
                        (CONTYPE = '2' or CONTYPE = '3' or CONTYPE = '4')) ">
   <xsl:text> RELY</xsl:text>
  </xsl:if>
  <xsl:if test="(FLAGS mod 128)>=64">
   <xsl:text> ALWAYS</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoPrimaryUnique">
  <xsl:param name="Property">0</xsl:param>
  <xsl:param name="HasPkOID">0</xsl:param>
  <xsl:param name="InColList" select="''"/>
  <!-- *******************************************************************
Template: DoPrimaryUnique
          Common processing for UNIQUE and PRIMARY KEY constraints
Parameters:
  Property: TABLE_T/PROPERTY
******************************************************************** -->
  <!-- Col list is not needed while enabling PK for PkOID -->
  <xsl:if test="not ($HasPkOID=1 and $InColList=0)">
   <xsl:text> (</xsl:text>
   <xsl:call-template name="DoConstraintColList">
    <xsl:with-param name="ConstraintColList" select="COL_LIST"/>
   </xsl:call-template>
   <xsl:text>)</xsl:text>
   <xsl:call-template name="DoFlags"/>
  </xsl:if>
  <!-- Process Unique and Primary key constraints 
         if Index exists AND 
            Index is not temp index with system generated name OR
                     not IOT Primary Key 
            AND not PkOID whose PK index was not created by constraint -->
  <xsl:if test="IND and $CONSTRAINT_USE_DEFAULT_INDEX = 0 and
                not (((IND/BASE_OBJ/FLAGS mod 4)>=2 and
                      starts-with(IND/SCHEMA_OBJ/NAME,'SYS_C')) or
                     (($Property mod 128)>=64 and CONTYPE='2')) and
                not ($HasPkOID=1 and $InColList=1 and (IND/PROPERTY mod 8192)&lt;4096)">
   <!--Adding Primary key or Unique constraint can happen in three types
       "Alter table 'tname' add constraint 'cname' 
             Type 1) -> primary key/unique ('colname') using index (create [unique] index ...)"
             Type 2) -> primary key/unique ('colname') using index 'schemaname.'indexname'"
             Type 3) -> primary key/unique ('colname') using index ... storage (...)"

       Type 1 is generated when:
                    Primary key or Unique key constraint        AND
                    Index was created by constraint             AND
                       Index is not system generated and
                       Index, Constraint names are different
                                   OR
                       Constraint name is system generated and 
                       index is marked as system generated      AND
                    Not online redefinition
       Type 2 is generated in following case :
             Index exists ( OR Index was not created by constraint and 
                               Index was not system generated and 
                               not Export or Has partition ref child table) AND
             Index is not system generated AND
             Not online redefinition.

       Type 3 is generated in following case :
             If index is not on temporary table then generate segment
                attributes and it will create unique index automatically 
                with constraint name.
    -->
   <xsl:variable name="Create_Idx_In_Constr" select="
    (CONTYPE='2' or CONTYPE='3') and
    (IND/PROPERTY mod 8192)>=4096 and
    ((not(starts-with(IND/SCHEMA_OBJ/NAME,'SYS_C')) and
      (NAME != IND/SCHEMA_OBJ/NAME)) or
     (not(starts-with(IND/SCHEMA_OBJ/NAME,'SYS_C')) and
      starts-with(NAME,'SYS_C') and
      (IND/SCHEMA_OBJ/FLAGS mod 8)>=4) or
     ($CONSTR_INDEX_FIDELITY=1 and 
      (not(starts-with(IND/SCHEMA_OBJ/NAME,'SYS_C'))))) and
    $ONLINE_REDEF!=1"/>
   <xsl:choose>
    <xsl:when test="$Create_Idx_In_Constr">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <!-- Add full CREATE INDEX clause -->
     <xsl:text> USING INDEX (</xsl:text>
     <xsl:apply-templates select="IND">
      <xsl:with-param name="ConstraintIndex">1</xsl:with-param>
     </xsl:apply-templates>
     <xsl:text>) </xsl:text>
    </xsl:when>
    <xsl:when test="(($INDEX_BY_NAME=1 and (IND/PROPERTY mod 8192)&lt;4096) or ($EXPORT=0 and (IND/PROPERTY mod 8192)&lt;4096 and not(starts-with(IND/SCHEMA_OBJ/NAME,'SYS_C')))) and 
                    (IND/SCHEMA_OBJ/FLAGS mod 8) &lt; 4 and $ONLINE_REDEF!=1">
     <!--When doing alter table add primary/unique, and we have an index which is not system generated, we want to name the index, so constraint enforcement will use that index.-->
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <!-- Add index attributes if being emitted -->
     <xsl:text> USING INDEX </xsl:text>
     <xsl:apply-templates select="IND/SCHEMA_OBJ"/>
    </xsl:when>
    <xsl:when test="2>(IND/BASE_OBJ/FLAGS mod 4)">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <!-- Add index attributes if being emitted -->
     <xsl:text> USING INDEX </xsl:text>
     <xsl:apply-templates select="IND">
      <xsl:with-param name="ConstraintIndex">2</xsl:with-param>
     </xsl:apply-templates>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:apply-templates select="ENABLED">
   <xsl:with-param name="HasPkOID" select="$HasPkOID"/>
   <xsl:with-param name="InColList" select="$InColList"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template name="DoConstraintColList">
  <xsl:param name="ConstraintColList" select="''"/>
  <!-- *******************************************************************
Template: DoConstraintColList
          (Sigh) Doing our own col list processing
Parameters:
  Property: ConstraintColList - parent of COL_LIST_ITEM
******************************************************************** -->
  <xsl:for-each select="$ConstraintColList/COL_LIST_ITEM |
         $ConstraintColList/SRC_COL_LIST_ITEM |
         $ConstraintColList/TGT_COL_LIST_ITEM">
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="COL"/>
   </xsl:call-template>
   <!-- Add Any Supplemental Log Group NO LOG clause -->
   <xsl:if test="(SPARE1 mod 2)=1"> NO LOG</xsl:if>
   <!-- Put out a ',' when not the last column -->
   <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="REFACT">
  <!-- *******************************************************************
Template: REFACT

******************************************************************** -->
  <xsl:if test="string-length($UNIQUE_NAME) = 0">
   <xsl:text> ON DELETE </xsl:text>
   <xsl:choose>
    <xsl:when test=".='1'">CASCADE</xsl:when>
    <xsl:when test=".='2'">SET NULL</xsl:when>
    <xsl:otherwise>SET DEFAULT</xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="ENABLED">
  <xsl:param name="HasPkOID">0</xsl:param>
  <xsl:param name="InColList" select="''"/>
  <!-- *******************************************************************
Template: ENABLED
******************************************************************** -->
  <xsl:choose>
   <!-- process [en/dis]able syntax -->
   <!-- force DISABLE when in Data Warehouse Cloud Services env for pk/uk/fk 
             Primary key = contype 2
             Unique       = contype 3
             Foreign key  = contype 4
             For PkOID, index was not generated by constraint 
        Note since we are forcing disable in this env we can not generate VALIDATE.
   -->
   <xsl:when test=".='0' or ($DWCS_CVT_CONSTRAINTS = 1 and 
                   (../CONTYPE = '2' or ../CONTYPE = '3' or ../CONTYPE = '4')) or
                   ($HasPkOID=1 and $InColList=1 and (../IND/PROPERTY mod 8192)&lt;4096)">
    <xsl:text> DISABLE</xsl:text>
    <!-- novalidate is default for disable, so check for validate only -->
    <xsl:if test="(../FLAGS mod 8) >= 4 and $DWCS_CVT_CONSTRAINTS = 0">
     <xsl:text> VALIDATE</xsl:text>
    </xsl:if>
   </xsl:when>
   <!-- ENABLE is not valid while enabling PK for PkOID when index was not created by constraint-->
   <xsl:when test="not ($HasPkOID=1 and $InColList=0 and (../IND/PROPERTY mod 8192)&lt;4096)">
    <xsl:text> ENABLE</xsl:text>
    <!-- validate is default for enable, so check for novalidate only -->
    <xsl:choose>
     <xsl:when test="../FLAGS">
      <xsl:if test="(../FLAGS mod 8) &lt; 4">
       <xsl:text> NOVALIDATE</xsl:text>
      </xsl:if>
     </xsl:when>
     <xsl:otherwise>
      <!-- this is NULL value -->
      <xsl:text> NOVALIDATE</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoHiddenConstraint">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="ConstraintNode" select="''"/>
  <!-- *******************************************************************
Template: DoHiddenConstraint

     HIDDEN_ID (OID or SETID) constraints/indexes.
     Only arrive here for TRANSPORTABLE=1 when some
      TABLE_T/CON1_LIST/$ConstraintNode[OID_OR_SETID] != 0.

     CREATE of an object table, and/or a table with nested columns will cause
     RDBMS to generate a unique constraint on the OID and/or each nested
     table's SETID respectively, which when enabled at the end of the RDBMS
     Create Table procedure, will create a UNIQUE index for that constraint.
     The constraint and index have system generated names, and the index will
     be flagged as having been created by a constraint.
     For an object table, any OIDINDEX clause information in the Create will
     be associated with the OID constraint and used during the implicit
     creation of the Unique OID index at the end of Create Table.

     For all Export modes, the OID and SETID Constraint (CONSTRAINT_T) and
     Index (INDEX_T) Objects are filtered out.  The only place the HIDDEN_ID
     constraint info appears is in the table (TABLE_T) object.  Currently, for
     all Import modes other than Transportable, these Table object constraints
     are ignored, as the constraints and associated indexes will be implictly
     re-created on Import (with any OIDINDEX clause information used for the
     OID index).
      
     For transportable mode, RDBMS creates but generally does not enable these
     constraints during CREATE TABLE (see bug 2347596 which now causes the OID
     constraint to be enabled).  This leaves disabled constraints as well
     as the UNIQUE index segments without corresponding index metadata.
     OIDINDEX clause information associated with the disabled OID constraint
     will never be used (see above for bug 2347596).
     
     For transportable mode, Import must generate and execute DDL to determine
     the OID/SETID constraint name in the target metadata, and enable those
     constraints.  The DDL is generated from constraint and index information
     in the [nested] Table Objects, providing explicit index storage info via
     the USING INDEX clause to reuse the existing index segments (any any
     OIDINDEX infor is then ignored).  The DDL is executed after the Create
     Table for each object table and each table with nested table columns.
     Note that re-enabling an enabled constraint does not present any problems.
 
     Unfortunately RDBMS does Not guarantee that the constraint is enabled or
     exists, that the index exists, that both have the same name, that the
     index is marked as having been created by a constraint, that either
     have not been redefined as named objects, that the index is unique, or
     that the constraint has been enabled/disabled with the 'current' defaults
     (such as [NO]VALIDATE), leading to the following:
    
     Not supported:
      Disabled constraints, with or without a retained index (can leave
       'detached' index segments with no index metadata).
      Dropped constraints, with or without a retained index (same problem
       with 'detached' index segments).
      Non Unique indexes (manually created or via DEFERRABLE constraints).
      Named constraints and/or named indexes (non system gen'd names).
      Clauses - NOVALIDATE (Unique index generation is only guaranteed to
                            occur with ENABLE VALIDATE),
                DROP/KEEP INDEX, DEFERRABLE, INITIALLY, RELY, EXCEPTIONS.
Parameters:
  SchemaObjParent:      TABLE_T node (for SCHEMA_OBJ child)
  ConstraintNode:       CON1 child node with OID_OR_SETID != 0
******************************************************************** -->
  <xsl:variable name="TableName">
   <xsl:choose>
    <xsl:when test="$FORCE_UNIQUE=1 and $SchemaObjParent/NTAB_NUM">
     <xsl:text>KU$</xsl:text>
     <xsl:value-of select="$SchemaObjParent/NTAB_NUM"/>
     <xsl:value-of select='"NT"'/>
     <xsl:value-of select="$SchemaObjParent/INTCOL_NUM"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="SchemaTableName">
   <xsl:choose>
    <xsl:when test="$FORCE_UNIQUE=1 and $SchemaObjParent/NTAB_NUM">
     <xsl:text>"</xsl:text>
     <xsl:value-of select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:text>".KU$</xsl:text>
     <xsl:value-of select="$SchemaObjParent/NTAB_NUM"/>
     <xsl:value-of select='"NT"'/>
     <xsl:value-of select="$SchemaObjParent/INTCOL_NUM"/>
     <xsl:value-of select='" "'/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType" select="$SchemaObjParent/SCHEMA_OBJ/TYPE_NAME"/>
   <xsl:with-param name="NameNode" select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>DECLARE</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> CON_NAME VARCHAR2(128);</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>BEGIN</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <!-- Get target constr. name for owner/table/seg. col. num of OID/SETID -->
  <xsl:text> EXECUTE IMMEDIATE</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  'SELECT CH.CONSTR_NAME </xsl:text>
  <xsl:text>FROM SYS.KU$_FIND_HIDDEN_CONS_VIEW CH ' ||</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  'WHERE CH.OWNER_NAME = :1 AND </xsl:text>
  <xsl:text>CH.TABLE_NAME = :2 AND ' ||</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>        'CH.SEGCOL_NUM = :3'</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  INTO CON_NAME</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  USING '</xsl:text>
  <xsl:call-template name="EnQuote">
   <xsl:with-param name="String" select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
  </xsl:call-template>
  <xsl:text>', '</xsl:text>
  <xsl:call-template name="EnQuote">
   <xsl:with-param name="String" select="$TableName"/>
  </xsl:call-template>
  <xsl:text>', </xsl:text>
  <xsl:value-of select="$ConstraintNode/COL_LIST/COL_LIST_ITEM/COL/SEGCOL_NUM"/>
  <xsl:text>;</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> EXECUTE IMMEDIATE</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  'ALTER </xsl:text>
  <xsl:value-of select="$SchemaObjParent/SCHEMA_OBJ/TYPE_NAME"/>
  <xsl:text> </xsl:text>
  <xsl:value-of select="$SchemaTableName"/>
  <xsl:text>' ||</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  'ENABLE </xsl:text>
  <xsl:text>CONSTRAINT "' || CON_NAME || '" ' ||</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  'USING INDEX </xsl:text>
  <xsl:apply-templates select="$ConstraintNode/IND">
   <xsl:with-param name="ConstraintIndex">2</xsl:with-param>
  </xsl:apply-templates>
  <xsl:text>';</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>END;</xsl:text>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
  <xsl:text>&#xa;</xsl:text>
 </xsl:template>
</xsl:stylesheet>
