<?xml version="1.0"?>
<!-- 

 Copyright (c) 2000, 2021, Oracle and/or its affiliates. 
NAME
    kuidxwrk.xsl
DESCRIPTION
    worker XSLT stylesheet for XML => DDL conversion of md$_index_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    apfwkr      03/10/21 - Backport
                           apfwkr_blr_backport_30978304_19.10.0.0.210119dbru
                           from st_rdbms_19.10.0.0.0dbru
    apfwkr      12/18/20 - Backport
                           apfwkr_blr_backport_30978304_19.9.0.0.201020dbru
                           from st_rdbms_19.9.0.0.0dbru
    apfwkr      09/02/20 - Backport
                           apfwkr_blr_backport_30978304_19.8.0.0.200714dbru
                           from st_rdbms_19.8.0.0.0dbru
    apfwkr      06/29/20 - Backport
                           apfwkr_blr_backport_30978304_19.7.0.0.200414dbru
                           from st_rdbms_19.7.0.0.0dbru
    apfwkr      05/27/20 - Backport sdavidso_bug-30978304 from main
     sdavidso    05/27/20 - bug-30978304 assure index creation by constraints
    apfwkr      11/19/18 - Backport sdavidso_bug-28719339 from main
    sdavidso    11/14/18 - bug28719339 - AUTO clause for indexes
    tbhukya     06/27/18 - RTI 21165472: Handle unusable indexes in move chunk
    tbhukya     04/25/18 - Bug 27890659: Handle merge partition option for
                           index on hybrid partition table.
    jjanosik    04/11/18 - Bug 27720184: do not emit INDEXING PARTIAL if we are
                           departitioning
    jjanosik    02/15/18 - LRG 21021955: fix condition added in the txn:
                           jjanosik_bug-27368347
    jjanosik    02/01/18 - Bug 27368347: omit partition stuff when
                           departitioning
    sdavidso    11/06/17 - Bug 27027703 - move chunk w/partial index
    sdavidso    09/11/17 - bug25453685 name mapping for domain indexes
    jjanosik    07/18/17 - Bug 26384085: Add unusable to index partition
    rapayne     06/29/17 - Bug 25690298: Fix parse item IND_SPARE4 when 
                           functional index is partitioned.
    rapayne     04/09/17 - Bug 25732728: INDEX_COMPRESSION_CLAUSE is not
                           getting applied if the table does not already have compress
                           attributes defined.
    rapayne     02/24/17 - lrg 20084769: fix compression check for departition
                           scenarios.
    mjangir     02/21/17 - Bug 22869914: handle unusable bitmap partitioned
                           index in tts mode
    sdavidso    02/07/17 - bug25440009 handle user name with apostrophe
    rapayne     01/19/17 - Bug 25244974: generate INVISIBLE/COMPRESS attributes
                           for global temp tables.
    tbhukya     11/17/16 - Bug 24829009: Generate INDEX DDL when FORCE_INDEX
                           param is set
    tbhukya     06/24/16 - Bug 23525291: Unusable indexes
    jjanosik    04/24/16 - bug 23090252 - ass a space after the
                           INDEX_COMPRESSION_CLAUSE
    mjangir     03/14/16 - bug 18366521: disable archive logging
    rapayne     01/30/16 - bug 22611512: fix variable Transportable
    sdavidso    12/10/15 - bug22264616 more move chunk subpart
    sdavidso    11/17/15 - bug21869037 chunk move w/subpartitions
    tbhukya     11/04/15 - Bug 22125304: Use original column name in index
                           when virtual column created for collation.
    sdavidso    08/20/15 - bug-20756759: lobs, indexes, droppped tables
    sdavidso    07/09/15 - bug21417801 move chunk fails
    tbhukya     07/07/15 - Bug 21310724: Use default value for dbc expression
    bwright     04/27/15 - Bug 20478020: Better handling of fake indexes
    tbhukya     02/25/15 - Proj 47173: Data bound collation
    tbhukya     01/05/15 - Bug 20319428: Declare referred params
    tbhukya     11/06/14 - Bug 19934581: Skip expression with SYS_PATH_REVERSE
    dvekaria    10/03/14 - Bug 19126076: INVISIBLE DDL for INVISIBLE XML INDEX.
    lbarton     08/06/14 - bug 19180774: parse JSON operators
    bwright     07/02/14 - Bug 19018545: Fix INVISIBLE support: for partitioned
                           index and only for versions greater than 11
    lbarton     07/02/14 - lrg 12378533: tolerate JSON operators
    lbarton     01/02/14 - bug 17943479: REMAP_SCHEMA for functional indexes
    dvekaria    11/28/13 - Bug 16700693 - Include COMPRESS to INDEX DDL.
    tbhukya     11/20/13 - Bug 17803321: Donot import unique indexes which
                           are associated with PK, Unique constraints. 
    lbarton     09/24/13 - bug 17236189: IND_SPARE4 parse item and transform
                           param
    bwright     08/15/13 - Bug 17312600: Remove hard tabs from DP src code
    lbarton     04/24/13 - bug 16716831: functional index expression as varchar
                           or clob
    lbarton     04/09/13 - bug 11769592: index name != constraint name
    xihua       10/11/12 - Index Compression Factoring Change
    traney      09/26/12 - move evaluation edition clauses to columns
    lbarton     08/30/12 - bug 14054759: exclude indexes with stale entries and
                           tables with online moved partitions
    traney      08/02/12 - 14407652: evaluation edition, unusable before
    rapayne     03/20/12 - proj 32423: OLTP Index compression support.
    lbarton     12/29/11 - bug 13419500: PARTITION_NAME for list/hash
                           partitioned index
    rapayne     12/25/11 - proj 37634: Partial Index support. 
    lbarton     09/29/11 - bug 12998411: INDEX_COMPRESSION_CLAUSE
    rapayne     03/20/11 - proj 30924: support disabling of archive logging.
    sdavidso    03/30/11 - support TRANSPORTABLE xml element
    tbhukya     04/25/11 - Bug 12321309: Generate alter stmt for unusable global
                           partitioned indexed in tts mode.
    lbarton     04/27/10 - bug 9650606: more dsc details
    lbarton     08/14/09 - bug 8795792: no compress/logging in deferred stg for
                           indexes
    dgagne      07/29/09 - add calls to patchdictionary
    rapayne     06/26/09 - bug 8664468/8592114 colname references to EXTRADATA
                           are not valid for index. Therefore, we force these to
                           OBJECT_VALUE.
    lbarton     03/19/09 - lrg 3762023: unusable index (sub)partitions and
                           transportable
    tbhukya     04/16/09 - Bug 8436781: NOSEGMENT for virtual index
    lbarton     02/26/09 - bug 8252494: more deferred segment creation
    rapayne     12/06/08 - merge BLOCKSIZE logic for CM
    lbarton     09/30/08 - bug 7334782 (again): more xmltype virtual columns
    lbarton     09/10/08 - bug 7362930: index (sub)partition UNUSABLE
    mjangir     06/10/08 - bug 7138608: dom idx partitions without parameters
    lbarton     11/26/07 - bug 6051635: null params on dom idx partitions
    lbarton     11/02/07 - bug 6605086: escape single quote
    htseng      06/15/07 - fix virtual column in DomainCol 
    htseng      04/10/07 - bug 5982584: domain indx column
    lbarton     10/23/06 - bug 5610872: composite domain indexes
    dgagne      05/23/06 - don't require transportable to departition an index 
    sdavidso    05/09/06 - support invisible index attribute 
    sdavidso    05/01/06 - support parameters in domain index partitions
    lbarton     01/27/06 - partition transportable 
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    sdavidso    09/23/05 - support NOCPRESS for slected partitions 
    htseng      08/08/05 - bug 3560220: get correct behavior from processor 
    baleti      06/03/05 - Bug 4357181: Add RPKE clause 
    htseng      02/10/05 - bug 3483988 : index REVERSE 
    dgagne      06/29/04 - only compute index stats if no export transform 
    htseng      05/18/04 - bug 3635820: check index unusable status
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    lbarton     12/16/03 - COMPRESS with part. idx 
    lbarton     10/14/03 - lrg 1582938: sort join tables for reproduc. results
    lbarton     07/18/03 - Bug 3045926: restructure ku_procobj_lines
    htseng      06/13/03 - bug 3006177 : PL/SQL BEGIN/END block too big
    emagrath    06/06/03 - Correct index info for constraints
    lbarton     05/07/03 - bug 2944274: bitmap join indexes
    lbarton     05/05/03 - remove quotes in dbms_export_extension calls
    lbarton     04/10/03 - Bug 2883530: params for partitioned domain index
    lbarton     03/06/03 - bug 2832345: no RESET_PARALLEL if idx on temp table
    lbarton     12/10/02 - new types for procedural objects
    lbarton     10/21/02 - add PARALLEL, RESET_PARALLEL params
    lbarton     10/11/02 - new parse item: SYSTEM_GENERATED
    lbarton     08/02/02 - transportable export
    lbarton     04/30/02 - add EXPORT transform param
    lbarton     04/26/02 - domain index support
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     10/24/00 - sort in views, not xsl
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     10/05/00 - cluster index
    lbarton     09/27/00 - bugfix: sort columns on pos_num
    lbarton     07/24/00 - use uriref in import
    lbarton     06/23/00 - parsing for PL/SQL code
    lbarton     06/14/00 - add PRS_TABLESPACE
    lbarton     06/01/00 - support parsing
    lbarton     05/15/00 - Params for new API
    lbarton     04/03/00 - Creation
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <xsl:import href="kuprtobj.xsl"/>
 <xsl:import href="kusparsdx.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PARALLEL">-1</xsl:param>
 <xsl:param name="RESET_PARALLEL">0</xsl:param>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <xsl:param name="PARTITION_NAME" select="''"/>
 <xsl:param name="SUBPARTITION_NAME" select="''"/>
 <xsl:param name="BASE_PARTITION_NAME" select="''"/>
 <xsl:param name="BASE_SUBPARTITION_NAME" select="''"/>
 <xsl:param name="INDEX_COMPRESSION_CLAUSE" select="''"/>
 <xsl:param name="FORCE_INDEX">0</xsl:param>
 <xsl:param name="UNIQUE_NAME" select="''"/>
 <!-- Parse item params -->
 <xsl:param name="PRS_IND_SPARE4">0</xsl:param>
 <xsl:param name="PRS_SYSTEM_GENERATED">0</xsl:param>
 <xsl:param name="PRS_ALT_CONNECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_TABLESPACE">0</xsl:param>
 <xsl:param name="PRS_CREATED_BY_CONSTRAINT">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="INDEX_T | IND">
  <xsl:param name="ConstraintIndex">0</xsl:param>
  <!--TRANSPORTABLE is valid for TABLE and TABLESPACE export, not DATABASE export.
    We define TransportObject to mean the current object is moved using trasportable
    see kutable.xsl for more details.
 -->
  <xsl:variable name="TransportObject">
   <xsl:choose>
    <xsl:when test="$TRANSPORTABLE = 0">0</xsl:when>
    <xsl:when test="$TRANSPORTABLE = 1">1</xsl:when>
    <xsl:when test='$TRANSPORTABLE = 2 and .//TRANSPORTABLE="1"'>1</xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <!-- If not a fake (nosegment) index, then it is a 'real' one -->
  <xsl:variable name="RealIndex">
   <xsl:choose>
    <xsl:when test="(FLAGS mod 8192)>=4096">0</xsl:when>
    <xsl:otherwise>1</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="ShardPartitionName">
   <xsl:choose>
    <xsl:when test="IND_PART">
     <xsl:value-of select="IND_PART/PART_NUM"/>
    </xsl:when>
    <xsl:when test="IND_SUBPART">
     <xsl:value-of select="TABPART_OBJ_NUM"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="ancestor::TABLE_T/OBJ_NUM"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="ancestor::TABLE_T/TABPART/PHYPART_NUM"/>
     <xsl:value-of select="ancestor::TABLE_T/SUBPART/PHYPART_NUM"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="FullTabName">
   <xsl:choose>
    <xsl:when test="string-length($UNIQUE_NAME) > 0">
     <xsl:text>KU$_</xsl:text>
     <xsl:value-of select="$UNIQUE_NAME"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="BASE_OBJ/OBJ_NUM"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="$ShardPartitionName"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="BASE_OBJ/NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="BASE_OBJ/NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <!--Get name of target table (on which the index is built)-->
  <xsl:variable name="QuotedTabName">
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="BASE_OBJ/OWNER_NAME"/>
    <xsl:with-param name="Object" select="$FullTabName"/>
    <xsl:with-param name="TrailingBlank" select='"1"'/>
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="IndexFullName">
   <xsl:choose>
    <xsl:when test="string-length($UNIQUE_NAME) > 0">
     <xsl:text>KU$_</xsl:text>
     <xsl:value-of select="$UNIQUE_NAME"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/OBJ_NUM"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="TABPART_OBJ_NUM"/>
     <xsl:text>_</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <!-- Only use input supplied degree of parallelism for real indexes.
       For fake indexes, always use the original amount (even though 
       it doesn't mean anything because there is nothing to load into
       a fake index; preserve it anyway). -->
  <xsl:variable name="RealParallel">
   <xsl:choose>
    <xsl:when test="$RealIndex=1">
     <xsl:value-of select="$PARALLEL"/>
    </xsl:when>
    <xsl:otherwise>-1</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <!-- *******************************************************************
Template: INDEX_T - top-level template for indexes.
           IND - indexes embedded in other types, e.g., constraints
 Parameters:
  ConstraintIndex:     0 - CREATE INDEX DDL statement
                       1 - CREATE INDEX clause in constraint
                       2 - only index attributes in constraint
******************************************************************** -->
  <xsl:choose>
    <!--Don't import index created by constraint. These are created when the
 constraint is created. FORCE_INDEX may overide this.

When constraints either dropped or disabled with KEEP INDEX 
 option, associated indexes may remain marked as created by constraint
 and not imported (no longer any constraint).
 To import these type of indexes, FORCE_INDEX param is set in worker
 layer during reprocess to import indexes.
   -->
   <xsl:when test="$EXPORT=1 and 
$ConstraintIndex=0 and 
(PROPERTY mod 8192)>=4096 and
$FORCE_INDEX=0">
    <!-- System generated indexes get created automatically with different
         name. So, Marking a parse item is not needed as they don't get
         matched in reprocessing phase. -->
    <xsl:if test="$PRS_CREATED_BY_CONSTRAINT=1 and 
                  not(starts-with(SCHEMA_OBJ/NAME,'SYS_C'))">
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>ACREATED_BY_CONSTRAINT</xsl:text>
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>B</xsl:text>
     <xsl:text>Y</xsl:text>
    </xsl:if>
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">BEGIN</xsl:with-param>
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    </xsl:call-template>
    <xsl:text>BEGIN NULL; END;</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/
</xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <!--Name mapping for move chunk with domain indexes-->
    <xsl:if test="string-length($UNIQUE_NAME)>0 and $ConstraintIndex=0">
     <xsl:call-template name="DoIndNameMap">
      <xsl:with-param name="FullName" select="$IndexFullName"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:if test="$ConstraintIndex=0">
     <!--
       Emit anonymous PLSQL blocks needed for export
      -->
     <xsl:if test="$EXPORT=1">
      <!-- insert secondary objects for domain indexes -->
      <xsl:apply-templates select="SECOBJS">
       <xsl:with-param name="IndexFullName" select="$IndexFullName"/>
       <xsl:with-param name="ShardPartitionName" select="$ShardPartitionName"/>
      </xsl:apply-templates>
      <!-- emit the domain index PLSQL code (from ODCIIndexGetMetadata) -->
      <xsl:apply-templates select="PLSQL_CODE/PLSQL">
       <xsl:with-param name="Objecttype">INDEX</xsl:with-param>
      </xsl:apply-templates>
     </xsl:if>
     <!--
       Generate parse items
       Note: in a non-partitioned table SPARE4 contains the index parameters.
             however, in a partitioned table the index params are in
             PART_OBJ/PARTOBJ/DEFPARAMETERS.
      -->
     <xsl:variable name="indexParams">
      <xsl:choose>
       <xsl:when test="PART_OBJ/PARTOBJ/DEFPARAMETERS">
        <xsl:value-of select="PART_OBJ/PARTOBJ/DEFPARAMETERS"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="SPARE4"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:variable>
     <xsl:if test="$PRS_IND_SPARE4=1">
      <xsl:value-of select="$PRS_DELIM"/>
      <xsl:text>AIND_SPARE4</xsl:text>
      <xsl:value-of select="$PRS_DELIM"/>
      <xsl:text>B</xsl:text>
      <xsl:value-of select="$indexParams"/>
     </xsl:if>
     <xsl:if test="$PRS_TABLESPACE=1">
      <xsl:value-of select="$PRS_DELIM"/>
      <xsl:text>ATABLESPACE</xsl:text>
      <xsl:value-of select="$PRS_DELIM"/>
      <xsl:text>B</xsl:text>
      <xsl:choose>
       <xsl:when test="(PART_OBJ)">
        <xsl:value-of select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="TS_NAME"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:if>
     <xsl:if test="$PRS_SYSTEM_GENERATED=1">
      <xsl:value-of select="$PRS_DELIM"/>
      <xsl:text>ASYSTEM_GENERATED</xsl:text>
      <xsl:value-of select="$PRS_DELIM"/>
      <xsl:text>E</xsl:text>
      <xsl:if test="(SCHEMA_OBJ/FLAGS mod 8)>=4">Y</xsl:if>
      <xsl:value-of select="$PRS_DELIM"/>
     </xsl:if>
     <xsl:call-template name="DoParse">
      <xsl:with-param name="Verb">CREATE</xsl:with-param>
      <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
      <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
      <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
     </xsl:call-template>
    </xsl:if>
    <!--
       do the CREATE INDEX statement
      -->
    <xsl:if test="$ConstraintIndex!=2">
     <xsl:choose>
      <!-- cluster index -->
      <xsl:when test="BASE_OBJ/TYPE_NUM=3">
       <xsl:text>CREATE INDEX </xsl:text>
       <xsl:apply-templates select="SCHEMA_OBJ"/>
       <xsl:text>ON CLUSTER </xsl:text>
       <xsl:apply-templates select="BASE_OBJ"/>
      </xsl:when>
      <!-- table index -->
      <xsl:otherwise>
       <xsl:text>CREATE </xsl:text>
       <!--'UNIQUE' or 'BITMAP'?-->
       <xsl:choose>
        <xsl:when test="TYPE_NUM='2'">BITMAP </xsl:when>
        <xsl:when test="(PROPERTY mod 2)=1">UNIQUE </xsl:when>
       </xsl:choose>
       <xsl:text>INDEX </xsl:text>
       <xsl:call-template name="QuoteObject">
        <xsl:with-param name="Schema" select="SCHEMA_OBJ/OWNER_NAME"/>
        <xsl:with-param name="Object" select="$IndexFullName"/>
        <xsl:with-param name="TrailingBlank" select='"1"'/>
       </xsl:call-template>
       <xsl:text>ON </xsl:text>
       <xsl:value-of select="$QuotedTabName"/>
       <!--
         Generate the column list
         NOTE: we do our own COL_LIST processing,
         not the one in kucolumn.xsl
         -->
       <xsl:choose>
        <!-- domain index (type=9) -->
        <xsl:when test="TYPE_NUM=9">
         <xsl:call-template name="DomainCol">
          <xsl:with-param name="ColListNode" select="COL_LIST"/>
          <xsl:with-param name="IndProperty" select="PROPERTY"/>
         </xsl:call-template>
        </xsl:when>
        <!-- not domain index -->
        <xsl:otherwise>
         <xsl:call-template name="DoColList">
          <xsl:with-param name="ColListNode" select="COL_LIST"/>
          <xsl:with-param name="IndProperty" select="PROPERTY"/>
         </xsl:call-template>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:if test="(PROPERTY mod 16)>=8">
        <!--automatic index support - new in rdbms 20C. Will error if not datapump import-->
        <xsl:text>AUTO </xsl:text>
       </xsl:if>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <xsl:if test="(PROPERTY mod 8)>=4">REVERSE </xsl:if>
    <!--  Explicitly turn off RPKE optimization for transportable 
          tablespaces, if disabled on IOT sec index -->
    <xsl:if test="($TransportObject=1 and
               ((PROPERTY mod 32768) &lt; 16384) 
               and ((FLAGS mod 256)>=128))">DISABLE_RPKE </xsl:if>
    <!-- if this is an index on a temporary table, skip segment attrs -->
    <xsl:if test="2>(BASE_OBJ/FLAGS mod 4)">
     <!-- if this is a bitmap join index, add the from-where clause -->
     <xsl:if test="(PROPERTY mod 2048)>=1024">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;  </xsl:text>
      </xsl:if>
      <xsl:apply-templates select="JIJOIN_TABS"/>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;  </xsl:text>
      </xsl:if>
      <xsl:apply-templates select="JIJOIN"/>
     </xsl:if>
     <xsl:if test="$ConstraintIndex!=2">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;  </xsl:text>
      </xsl:if>
     </xsl:if>
     <!--
      Index Properties
       Note - partial indexing does not apply for MOVE CHUNK or 
              non-partitioned tables. 
              Applicable to hybrid partition index -->
     <xsl:if test="($PARTITIONING=1 or (BASE_PROPERTY3 mod 134217728)>=67108864) and 
                   (string-length($PARTITION_NAME)=0) and
                   (string-length($SUBPARTITION_NAME)=0) and
                   (FLAGS mod (8388608*2))>=8388608 and string-length($UNIQUE_NAME) = 0">
      <xsl:text>INDEXING PARTIAL </xsl:text>
     </xsl:if>
     <xsl:choose>
      <!-- domain index (type=9) -->
      <xsl:when test="TYPE_NUM=9">
       <xsl:call-template name="DomainIndexClause"/>
      </xsl:when>
      <xsl:otherwise>
       <!-- not domain index -->
       <xsl:choose>
        <!-- Partitioned index (both LOCAL and GLOBAL) -->
        <xsl:when test="(PART_OBJ)">
         <xsl:choose>
          <xsl:when test="(PART_OBJ/PARTOBJ/PARTTYPE=1 or
                           PART_OBJ/PARTOBJ/PARTTYPE=2 or
                           PART_OBJ/PARTOBJ/PARTTYPE=4)
                           and
                          (string-length($PARTITION_NAME)!=0 or
                           string-length($SUBPARTITION_NAME)!=0 or
                           string-length($BASE_PARTITION_NAME)!=0 or
                           string-length($BASE_SUBPARTITION_NAME)!=0)">
           <!-- convert (sub)partition of local partidx for partition tte -->
           <xsl:call-template name="CvtToNPIdx"/>
          </xsl:when>
          <xsl:otherwise>
           <xsl:call-template name="PartitionedIndexProperties"/>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
         <!-- non-partitioned -->
         <xsl:call-template name="IndexAttributes">
          <xsl:with-param name="attrNode" select="current()"/>
         </xsl:call-template>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:if test="$ConstraintIndex=0">
      <xsl:if test="$SEGMENT_ATTRIBUTES=1">
       <xsl:call-template name="DoParallel">
        <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
        <xsl:with-param name="FlagsParent" select="current()"/>
        <xsl:with-param name="SetParallel" select="$RealParallel"/>
       </xsl:call-template>
      </xsl:if>
      <xsl:if test="$RealIndex=0">
       <xsl:text> NOSEGMENT </xsl:text>
      </xsl:if>
     </xsl:if>
    </xsl:if>
    <!-- Indexes on temp tables have different attributes and must be treated separately -->
    <xsl:if test="(BASE_OBJ/FLAGS mod 4) >= 2">
     <xsl:call-template name="TempTableIndexAttributes">
      <xsl:with-param name="attrNode" select="current()"/>
     </xsl:call-template>
    </xsl:if>
    <!-- check INDEX if unusable AND
               Transportable
                        OR
               Index as part of add constraint -->
    <xsl:if test="(FLAGS mod 2)>=1 and ($TransportObject=1 or
                                       $ConstraintIndex=1)">
     <xsl:text> UNUSABLE</xsl:text>
    </xsl:if>
    <xsl:if test="$ConstraintIndex=0">
     <!-- Terminate the SQL statement -->
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
     </xsl:if>
     <!-- Only alter real index (cannot alter a fake, nosegment, index) -->
     <xsl:if test="$RealIndex=1">
      <xsl:call-template name="DoIdxAlters">
       <xsl:with-param name="TransportObject" select="$TransportObject"/>
      </xsl:call-template>
     </xsl:if>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoIdxAlters">
  <xsl:param name="TransportObject">0</xsl:param>
  <!-- *******************************************************************
Template: DoIdxAlters - Do the various ALTER INDEX statements
   This was moved to its own template to make sure it is only invoked
   when ConstraintIndex=0 (see above)
 Parameters:
  TransportObject: 1 = move the object using transportable
                   0 = don't
******************************************************************** -->
  <!--
      Reset parallel if requested (but not if index is on temporary table) 
-->
  <xsl:if test="$RESET_PARALLEL!=0 and 2>(BASE_OBJ/FLAGS mod 4)">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> ALTER INDEX </xsl:text>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:choose>
    <xsl:when test="DEGREE">
     <xsl:text>PARALLEL </xsl:text>
     <xsl:if test="32767>DEGREE">
      <xsl:value-of select="DEGREE"/>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>NOPARALLEL</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <!-- Terminate the CREATE INDEX statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- check INDEX if unusable -->
  <!-- for transportable we use the UNUSABLE keyword in the CREATE (above)
  -->
  <xsl:if test="(FLAGS mod 2)=1 and $TransportObject=0">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> ALTER INDEX </xsl:text>
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:text> UNUSABLE</xsl:text>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- unusable (sub)partitions: for TRANSPORTABLE we use the UNUSABLE keyword
       on the partition (see DoPartSegAttrs in kuprtobj.xsl) -->
  <!-- Bug 12321309: Generate alter stmt for unusable global partitioned index 
       in tts mode  -->
  <xsl:if test="$TransportObject=0 or ((PART_OBJ/PARTOBJ/FLAGS mod 4 >= 2) and 
                $TransportObject=1)">
   <xsl:call-template name="DoUnusablePartitions">
    <xsl:with-param name="Idx" select="."/>
   </xsl:call-template>
  </xsl:if>
  <!-- If transportable and the flags field is not null, then call
       patchdictionary -->
  <xsl:if test="($TransportObject=1 and
                 TYPE_NUM=2 and
                 FLAGS>0)">
   <!-- Calls to dbms_plugtsp need to be run while connected to the schema
        running the job.  Add a parse item ALT_CONNECT_TYPE=NONE -->
   <xsl:if test="$PRS_ALT_CONNECT_TYPE=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>AALT_CONNECT_TYPE</xsl:text>
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>BNONE</xsl:text>
   </xsl:if>
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_PLUGTSP.PATCHDICTIONARY</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
   </xsl:call-template>
   <xsl:text>BEGIN </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>SYS.DBMS_PLUGTSP.PATCHDICTIONARY('</xsl:text>
   <xsl:call-template name="EnQuote">
    <xsl:with-param name="String" select="BASE_OBJ/OWNER_NAME"/>
   </xsl:call-template>
   <xsl:text>','</xsl:text>
   <xsl:call-template name="EnQuote">
    <xsl:with-param name="String" select="BASE_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:text>','</xsl:text>
   <xsl:call-template name="EnQuote">
    <xsl:with-param name="String" select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:call-template>
   <xsl:text>','</xsl:text>
   <xsl:call-template name="EnQuote">
    <xsl:with-param name="String" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:text>',</xsl:text>
   <xsl:value-of select="FLAGS"/>
   <xsl:text>,'unused','unused',1); </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>END;</xsl:text>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>
/
</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="$DISABLE_ARCHIVE_LOGGING = '1' and 
                2>(BASE_OBJ/FLAGS mod 4)">
   <xsl:if test="(FLAGS mod 8)  &lt; 4">
    <!-- If disable_archive_logging was requested we disable logging 
          within the create ddl. Then after the index is created/built
          we restore the original behavior with an addition alter index.
    -->
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">ALTER</xsl:with-param>
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> ALTER INDEX </xsl:text>
    <xsl:apply-templates select="SCHEMA_OBJ"/>
    <xsl:text> LOGGING </xsl:text>
   </xsl:if>
   <!-- Terminate the CREATE INDEX statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoColList">
  <xsl:param name="ColListNode" select="''"/>
  <xsl:param name="IndProperty" select="''"/>
  <!-- *******************************************************************
Template: DoColList - col list processing for indexes
Parameters:
  ColListNode: COL_LIST
  IndProperty: PROPERTY
******************************************************************** -->
  <xsl:text>(</xsl:text>
  <xsl:for-each select="$ColListNode/COL_LIST_ITEM">
   <!--xsl:sort select="POS_NUM" data-type="number"/-->
   <xsl:choose>
    <!-- check PROPERTY flags: functional index virt column is marked
     both virtual and hidden
                /* 0x0020 =      32 = hidden column                          */
            /* 0x00010000 =   65536 = virtual column                         */
     In such case we put out col$.default$ which contains the
     defining functional expression.
     HOWEVER, if this bit
                /* 0x0008 =       8 = virtual column                         */
     is also set and these bits are clear:
                /* 0x0100 =     256 = system-generated column                */
                /* 0x0200 =     512 = rowinfo column of typed table/view     */
                /* 0x4000 =   16384 = dropped column                         */
     that means it is an XMLType virtual column, and we should use the
     column name.
-->
    <xsl:when test="(COL/PROPERTY mod 16 >= 8) and
                    (COL/PROPERTY mod 64 >= 32) and
                    (COL/PROPERTY mod 131052 >= 65536) and
                    (256 > (COL/PROPERTY mod 512)) and
                    (512 > (COL/PROPERTY mod 1024)) and
                    (16384 > (COL/PROPERTY mod 32768))">
     <!-- xmltype virtual column: use column name -->
     <xsl:call-template name="DoIdxColName">
      <xsl:with-param name="ColNode" select="COL"/>
      <xsl:with-param name="IndProperty" select="$IndProperty"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:when test="((COL/PROPERTY mod 64)>=32 
                    and (COL/PROPERTY mod 131072)>=65536)">
     <xsl:variable name="hasMAKEXML" select="contains(COL/DEFAULT_VAL,'SYS_MAKEXML')"/>
     <xsl:variable name="hasJSON" select="contains(COL/DEFAULT_VAL,'JSON_TABLE')"/>
     <xsl:variable name="hasSPATHR" select="contains(COL/DEFAULT_VAL,'SYS_PATH_REVERSE')"/>
     <xsl:choose>
      <!-- cannot parse SYS_MAKEXML so do not try -->
      <!-- lrg 12378533: skip expressions with JSON_TABLE operator -->
      <!-- Bug 19934581: Skip expressions with SYS_PATH_REVERSE operator 
           for a index on xml token set entity table -->
      <!-- Cannot parse default collation -->
      <xsl:when test="COL/COL_EXPR and not ($hasMAKEXML) and not ($hasJSON) and
                      not ($hasSPATHR) and not(COL/COL_EXPR/COLLATE  or
                                               COL/COL_EXPR/NLSSORT/COLLATE)">
       <xsl:apply-templates select="COL/COL_EXPR"/>
      </xsl:when>
      <xsl:when test="ORG_COL_NAME">
       <xsl:call-template name="QuoteObject">
        <xsl:with-param name="Schema" select="ORG_COL_NAME"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <!-- functional index -->
       <!--either DEFAULT_VAL or DEFAULT_VALC will be present but not both-->
       <xsl:value-of select="COL/DEFAULT_VAL"/>
       <xsl:value-of select="COL/DEFAULT_VALC"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>
    <!-- Note: colname references to XMLEXTRA.EXTRADATA are not valid
           for indexes. Therefore, we force the colname to OBJECT_VALUE.
     -->
    <xsl:when test="(COL/PROPERTY mod 64 >= 32) and
                      (COL/PROPERTY mod 256 >= 128) and
                      (contains(COL/ATTRNAME, 'EXTRADATA'))">
     <xsl:text>OBJECT_VALUE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoIdxColName">
      <xsl:with-param name="ColNode" select="COL"/>
      <xsl:with-param name="IndProperty" select="$IndProperty"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
   <!-- DESCending order index is bit 0x20000 (131072) in col$.property -->
   <xsl:if test="(COL/PROPERTY mod 262144)>=131072"> DESC</xsl:if>
   <!-- Put out a ',' when not the last column -->
   <!-- Otherwise, terminate the col. list -->
   <xsl:choose>
    <xsl:when test="not(position()=last())">
     <xsl:text>, </xsl:text>
    </xsl:when>
    <xsl:otherwise>) </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoIdxColName">
  <xsl:param name="ColNode" select="''"/>
  <xsl:param name="IndProperty" select="''"/>
  <!-- *******************************************************************
Template: DoIdxColName - generate index column name
Parameters:
  ColNode: COL
  IndProperty: PROPERTY
******************************************************************** -->
  <!-- if this is a bitmap join index, prefix column name with table alias -->
  <xsl:if test="($IndProperty mod 2048)>=1024">
   <xsl:text>"T</xsl:text>
   <xsl:value-of select="$ColNode/OBJ_NUM"/>
   <xsl:text>".</xsl:text>
  </xsl:if>
  <xsl:call-template name="ColNameOrAttr">
   <xsl:with-param name="ColItem" select="$ColNode"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoIndNameMap">
  <xsl:param name="FullName" select="'KU$_UniqueName'"/>
  <!-- ***************************************************** -->
  <!--insert into name mapping table-->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb" select="'NameMapInsert'"/>
   <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:text>BEGIN </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:text> INSERT INTO sys.ku$_shard_domidx_namemap (owner, source_name, target_name,type_name,part_name) values (</xsl:text>
  <xsl:call-template name="EnQuote">
   <xsl:with-param name="Enclose" select="'1'"/>
   <xsl:with-param name="String" select="SCHEMA_OBJ/OWNER_NAME"/>
  </xsl:call-template>
  <xsl:text>,</xsl:text>
  <xsl:call-template name="EnQuote">
   <xsl:with-param name="Enclose" select="'1'"/>
   <xsl:with-param name="String" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>,</xsl:text>
  <xsl:call-template name="EnQuote">
   <xsl:with-param name="Enclose" select="'1'"/>
   <xsl:with-param name="String" select="$FullName"/>
  </xsl:call-template>
  <xsl:text>,</xsl:text>
  <xsl:call-template name="EnQuote">
   <xsl:with-param name="Enclose" select="'1'"/>
   <xsl:with-param name="String" select="'INDEX'"/>
  </xsl:call-template>
  <xsl:text>,</xsl:text>
  <xsl:call-template name="EnQuote">
   <xsl:with-param name="Enclose" select="'1'"/>
   <xsl:with-param name="String" select="IND_PART/SCHEMA_OBJ/SUBNAME"/>
  </xsl:call-template>
  <xsl:text>); COMMIT; END;</xsl:text>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DomainCol">
  <xsl:param name="ColListNode" select="''"/>
  <xsl:param name="IndProperty" select="''"/>
  <!-- *******************************************************************
Template: DomainCol - col processing for domain index
Parameters:
  ColListNode: COL_LIST
  IndProperty: PROPERTY
******************************************************************** -->
  <xsl:text>(</xsl:text>
  <xsl:for-each select="$ColListNode/COL_LIST_ITEM[POS_NUM=1]">
   <!-- pos_num =1 is the domain index col -->
   <xsl:choose>
    <!-- check PROPERTY flags: functional index virt column is marked
     both virtual and hidden
                /* 0x0020 =      32 = hidden column                          */
            /* 0x00010000 =   65536 = virtual column                         */
     In such case we put out col$.default$ which contains the
     defining functional expression.
-->
    <!-- Note: colname references to XMLEXTRA.EXTRADATA are not valid
           for indexes. Therefore, we force the colname to OBJECT_VALUE.
     -->
    <xsl:when test="((COL/PROPERTY mod 64)>=32 
                 and (COL/PROPERTY mod 131072)>=65536)">
     <!--either DEFAULT_VAL or DEFAULT_VALC will be present but not both-->
     <xsl:value-of select="COL/DEFAULT_VAL"/>
     <xsl:value-of select="COL/DEFAULT_VALC"/>
    </xsl:when>
    <xsl:when test="(COL/PROPERTY mod 64 >= 32) and
                      (COL/PROPERTY mod 256 >= 128) and
                      (contains(COL/ATTRNAME, 'EXTRADATA'))">
     <xsl:text>OBJECT_VALUE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <!-- if this is a bitmap join index, prefix column name with table alias -->
     <xsl:if test="($IndProperty mod 2048)>=1024">
      <xsl:text>"T</xsl:text>
      <xsl:value-of select="COL/OBJ_NUM"/>
      <xsl:text>".</xsl:text>
     </xsl:if>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="COL"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
  <xsl:text>) </xsl:text>
 </xsl:template>
 <xsl:template match="JIJOIN_TABS">
  <!-- *******************************************************************
Template: JIJOIN_TABS 
  - template for bitmap join index FROM... WHERE... clause 
******************************************************************** -->
  <xsl:for-each select="JIJOIN_TABS_ITEM">
   <xsl:sort select="NAME"/>
   <xsl:if test="position()=1">
    <xsl:text> FROM </xsl:text>
   </xsl:if>
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Schema" select="OWNER_NAME"/>
    <xsl:with-param name="Object" select="NAME"/>
   </xsl:call-template>
   <xsl:text> "T</xsl:text>
   <xsl:value-of select="TABOBJ_NUM"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="JIJOIN">
  <!-- *******************************************************************
Template: JIJOIN
******************************************************************** -->
  <xsl:for-each select="JIJOIN_ITEM">
   <xsl:choose>
    <xsl:when test="position()=1">
     <xsl:text> WHERE </xsl:text>
    </xsl:when>
    <xsl:otherwise>AND </xsl:otherwise>
   </xsl:choose>
   <xsl:text>"T</xsl:text>
   <xsl:value-of select="TAB1OBJ_NUM"/>
   <xsl:text>"."</xsl:text>
   <xsl:value-of select="TAB1COL/NAME"/>
   <xsl:text>"="T</xsl:text>
   <xsl:value-of select="TAB2OBJ_NUM"/>
   <xsl:text>"."</xsl:text>
   <xsl:value-of select="TAB2COL/NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DomainIndexClause">
  <!-- *******************************************************************
Template: DomainIndexClause
  Index properties for a domain index
******************************************************************** -->
  <xsl:text> INDEXTYPE IS "</xsl:text>
  <xsl:value-of select="INDTYPE_OWNER"/>
  <xsl:text>"."</xsl:text>
  <xsl:value-of select="INDTYPE_NAME"/>
  <xsl:text>" </xsl:text>
  <!-- Invisible if bit 0x200000 in FLAGS=1 -->
  <xsl:if test="$VERSION >=1100000000 and  
                    (FLAGS mod 4194304) >= 2097152">INVISIBLE </xsl:if>
  <!-- FILTER BY -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(FLAGS mod 8)>=4]">
   <xsl:if test="position()=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <xsl:text> FILTER BY </xsl:text>
   </xsl:if>
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="COL"/>
   </xsl:call-template>
   <xsl:if test="not(position()=last())">, </xsl:if>
  </xsl:for-each>
  <!-- ORDER BY -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(FLAGS mod 16)>=8]">
   <xsl:sort select="SPARE3" data-type="number"/>
   <xsl:if test="position()=1">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;   </xsl:text>
    </xsl:if>
    <xsl:text> ORDER BY </xsl:text>
   </xsl:if>
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="COL"/>
   </xsl:call-template>
   <xsl:if test="(FLAGS mod 4)>=2"> DESC</xsl:if>
   <xsl:if test="not(position()=last())">, </xsl:if>
  </xsl:for-each>
  <xsl:choose>
   <xsl:when test="PART_OBJ">
    <!-- Partitioned domain index -->
    <xsl:if test="PART_OBJ/PARTOBJ/DEFPARAMETERS">
     <xsl:text> PARAMETERS (</xsl:text>
     <xsl:call-template name="EscapeString">
      <xsl:with-param name="OrigStr" select="PART_OBJ/PARTOBJ/DEFPARAMETERS"/>
      <xsl:with-param name="Leading">'</xsl:with-param>
      <xsl:with-param name="Trailing">'</xsl:with-param>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:if>
    <!-- Bug 27368347: if we are not departitioning, emit the partition clauses -->
    <xsl:if test="($PARTITIONING=1) and (string-length($PARTITION_NAME)=0) and
                  (string-length($SUBPARTITION_NAME)=0)">
     <xsl:text> LOCAL </xsl:text>
     <xsl:for-each select="PART_OBJ/PART_LIST/PART_LIST_ITEM">
      <xsl:if test="position()=1">(</xsl:if>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;   </xsl:text>
      </xsl:if>
      <xsl:text>PARTITION "</xsl:text>
      <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
      <xsl:text>"</xsl:text>
      <xsl:if test="PARAMETERS">
       <xsl:text> PARAMETERS (</xsl:text>
       <xsl:call-template name="EscapeString">
        <xsl:with-param name="OrigStr" select="PARAMETERS"/>
        <xsl:with-param name="Leading">'</xsl:with-param>
        <xsl:with-param name="Trailing">'</xsl:with-param>
       </xsl:call-template>
       <xsl:text>)</xsl:text>
      </xsl:if>
      <!-- if we are not forced to use an alter, make the partition unusable inline -->
      <xsl:if test="($ALTER_INDEX_PART_UNUSABLE=0) and (FLAGS mod 2)=1">
       <xsl:text> UNUSABLE </xsl:text>
      </xsl:if>
      <xsl:choose>
       <xsl:when test="position()=last()">)</xsl:when>
       <xsl:otherwise>, </xsl:otherwise>
      </xsl:choose>
     </xsl:for-each>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <!-- non-partitioned -->
    <xsl:if test="SPARE4">
     <xsl:text> PARAMETERS (</xsl:text>
     <xsl:call-template name="EscapeString">
      <xsl:with-param name="OrigStr" select="SPARE4"/>
      <xsl:with-param name="Leading">'</xsl:with-param>
      <xsl:with-param name="Trailing">'</xsl:with-param>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="PartitionedIndexProperties">
  <!-- *******************************************************************
Template: PartitionedIndexProperties
- emit properties for partitioned index
******************************************************************** -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:call-template name="DoPartObjSegAttrs">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   </xsl:call-template>
   <!-- Invisible if bit 0x200000 in FLAGS=1 -->
   <xsl:if test="$VERSION >=1100000000 and  
                     (FLAGS mod 4194304) >= 2097152">INVISIBLE </xsl:if>
   <xsl:call-template name="DoPartObjLogging"/>
   <xsl:call-template name="DoPartObjStorage">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
   <xsl:call-template name="DoPartObjTablespace"/>
  </xsl:if>
  <xsl:call-template name="DoPartitionClause">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   <xsl:with-param name="PartCompress" select="((FLAGS mod 64)>=32) and NUMKEYCOLS and (NUMKEYCOLS > 0)"/>
   <!-- Merge option is not applicable to index on hybrid partition table-->
   <xsl:with-param name="HybPartTab" select="(BASE_PROPERTY3 mod 134217728)>=67108864"/>
  </xsl:call-template>
  <xsl:call-template name="DoIndCompress">
   <xsl:with-param name="attrNode" select="current()"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoIndCompress">
  <xsl:param name="attrNode" select="''"/>
  <!-- *******************************************************************
Template: DoIndCompress
 Generate the index compression clause
Parameters:
 attrNode: parent of attribute nodes
******************************************************************** -->
  <xsl:variable name="dePartitioning" select="string-length($PARTITION_NAME)!=0 or
                                              string-length($SUBPARTITION_NAME)!=0"/>
  <xsl:choose>
   <!-- Note: INDEX_COMPRESSION_CLAUSE must not be applied during a
       transportable operation. The mixed case Index_Compression_Clause variable
       (defined in kuprtobj) accounts for this and will not reflect the actual
       transform param when transportable is set. 
    -->
   <xsl:when test="string-length($Index_Compression_Clause) !=0">
    <xsl:choose>
     <xsl:when test="$Index_Compression_Clause = 'NONE'"/>
     <xsl:otherwise>
      <xsl:value-of select="$Index_Compression_Clause"/>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>
   </xsl:when>
   <!--advanced high index compression : 0x40000000 -->
   <xsl:when test="$VERSION >=1200000000 and 
                   ($attrNode/FLAGS mod (2147483648*2))>=2147483648">
    <xsl:text>COMPRESS ADVANCED LOW </xsl:text>
   </xsl:when>
   <!--  advanced low index compression: 0x80000000 -->
   <xsl:when test="$VERSION >=1200000000 and 
                   ($attrNode/FLAGS mod (2147483648))>=1073741824">
    <xsl:text>COMPRESS ADVANCED HIGH </xsl:text>
   </xsl:when>
   <!--  BUG 16700693. Output COMPRESS when importing compressed partition -->
   <xsl:when test="(($attrNode/FLAGS mod 64)>=32 and NUMKEYCOLS) or
                     ( $dePartitioning and ($attrNode/FLAGS mod (2048)) >=1024)">
    <xsl:text>COMPRESS </xsl:text>
    <xsl:value-of select="$attrNode/NUMKEYCOLS"/>
    <xsl:text> </xsl:text>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CvtToNPIdx">
  <!-- *******************************************************************
Template: CvtToNPIdx
- Convert a local index (sub)partition to a non-partitioned index
  for partition transportable
Current node: parent of PART_OBJ
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($PARTITION_NAME)!=0 or
                     string-length($BASE_PARTITION_NAME)!=0">
    <xsl:call-template name="CvtIdxPart"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="CvtIdxSubPart"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CvtIdxPart">
  <!-- *******************************************************************
Template: CvtIdxPart
- Convert a local index partition to a non-partitioned index
  for partition transportable
Current node: parent of PART_OBJ
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($PARTITION_NAME)!=0">
    <xsl:choose>
     <xsl:when test="PART_OBJ/PART_LIST/PART_LIST_ITEM">
      <xsl:call-template name="IndexAttributes">
       <xsl:with-param name="attrNode" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:when test="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM">
      <xsl:call-template name="CvtPartIndexAttributes">
       <xsl:with-param name="attrNode" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]"/>
       <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
       <xsl:with-param name="Part_objNode" select="PART_OBJ"/>
      </xsl:call-template>
     </xsl:when>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="IndexAttributes">
     <xsl:with-param name="attrNode" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[TAB_PART_NAME=$BASE_PARTITION_NAME]"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CvtIdxSubPart">
  <!-- *******************************************************************
Template: CvtIdxSubPart
- Convert a local index subpartition to a non-partitioned index
  for partition transportable
Current node: parent of PART_OBJ
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($SUBPARTITION_NAME)!=0">
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/PCT_FREE">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/STORAGE">
     <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/DATAOBJ_NUM"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/PCT_FREE">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/STORAGE">
     <xsl:with-param name="PARTITION">1</xsl:with-param>
     <xsl:with-param name="BlkSize" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[TAB_SUBPART_NAME=$BASE_SUBPARTITION_NAME]/DATAOBJ_NUM"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="IndexAttributes">
  <xsl:param name="attrNode" select="''"/>
  <!-- *******************************************************************
Template: IndexAttributes
- emit index attributes for non-partitioned index
Parameters:
 attrNode: parent of attribute nodes
******************************************************************** -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:apply-templates select="$attrNode/PCT_FREE">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   </xsl:apply-templates>
   <!-- Invisible if bit 0x200000 in FLAGS=1 -->
   <xsl:if test="$VERSION >=1100000000 and  
                ($attrNode/FLAGS mod 4194304) >= 2097152">INVISIBLE </xsl:if>
   <xsl:if test="($EXPORT = 0) and
                 ($attrNode/FLAGS mod 4)>=2">COMPUTE STATISTICS </xsl:if>
   <xsl:call-template name="DoIndCompress">
    <xsl:with-param name="attrNode" select="$attrNode"/>
   </xsl:call-template>
   <xsl:choose>
    <xsl:when test="$attrNode/DEFERRED_STG">
     <!-- DoDeferredStg does index logging as well as storage -->
     <xsl:call-template name="DoDeferredStg">
      <xsl:with-param name="DeferredStg" select="$attrNode/DEFERRED_STG"/>
      <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
      <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
     </xsl:call-template>
     <xsl:if test="$TABLESPACE=1">
      <xsl:apply-templates select="$attrNode/TS_NAME"/>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoIndLogging">
      <xsl:with-param name="FlagsNode" select="$attrNode/FLAGS"/>
     </xsl:call-template>
     <xsl:if test="$attrNode/STORAGE">
      <xsl:apply-templates select="$attrNode/STORAGE">
       <xsl:with-param name="BlkSize" select="$attrNode/../BLOCKSIZE | $attrNode/BLOCKSIZE"/>
       <xsl:with-param name="Dataobjnum" select="$attrNode/DATAOBJ_NUM | $attrNode/SCHEMA_OBJ/DATAOBJ_NUM"/>
       <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
      </xsl:apply-templates>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="TempTableIndexAttributes">
  <xsl:param name="attrNode" select="''"/>
  <!-- *******************************************************************
Template: TempTableIndexAttributes
- emit index attributes for indexes on temporary tables
Note: Index attribs on temp tables are a limited subset of attribs for other indexes 
    and are easier if treated independently in turms of deterministic attribute ordering
    on resultant generated ddl.
Parameters:
 attrNode: parent of attribute nodes
******************************************************************** -->
  <!-- Invisible if bit 0x200000 in FLAGS=1 -->
  <xsl:if test="$VERSION >=1100000000 and  
                ($attrNode/FLAGS mod 4194304) >= 2097152">INVISIBLE </xsl:if>
  <xsl:call-template name="DoIndCompress">
   <xsl:with-param name="attrNode" select="$attrNode"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="CvtPartIndexAttributes">
  <xsl:param name="attrNode" select="''"/>
  <xsl:param name="Part_objNode" select="''"/>
  <xsl:param name="BlkSize">0</xsl:param>
  <!-- *******************************************************************
Template: CvtPartIndexAttributes
- emit index attributes for partition of composite partitioned index
Parameters:
  attrNode: parent of attribute nodes
  Part_objNode: PART_OBJ node
  BlkSize: value of BLOCKSIZE
******************************************************************** -->
  <xsl:variable name="SubPartType" select="$Part_objNode/PARTOBJ/SPARE2 mod 256"/>
  <xsl:variable name="Local">
   <xsl:choose>
    <xsl:when test="($Part_objNode/PARTOBJ/FLAGS mod 2)=1">1</xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:apply-templates select="$attrNode/DEFPCTFREE">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   </xsl:apply-templates>
   <xsl:apply-templates select="$attrNode/DEFLOGGING"/>
   <xsl:call-template name="DoDefStorage">
    <xsl:with-param name="Node" select="$attrNode"/>
    <xsl:with-param name="BlkSize" select="$BlkSize"/>
   </xsl:call-template>
   <xsl:if test="$TABLESPACE=1">
    <xsl:apply-templates select="$Part_objNode/DEFTS_NAME"/>
   </xsl:if>
   <xsl:if test="$Local=1"> LOCAL </xsl:if>
   <xsl:for-each select="$Part_objNode/COMPART_LIST/COMPART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]">
    <xsl:for-each select="SUBPARTS/SUBPARTS_ITEM">
     <!-- emit the initial open paren -->
     <xsl:if test="position()=1">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
      <xsl:text> (</xsl:text>
     </xsl:if>
     <xsl:call-template name="DoPartListItem">
      <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
      <xsl:with-param name="PartobjNode" select="$Part_objNode/PARTOBJ"/>
      <xsl:with-param name="Parttype" select="$SubPartType"/>
      <xsl:with-param name="Local" select="$Local"/>
     </xsl:call-template>
     <!-- 
         Put out a comma / LF if not the last partition
     -->
     <xsl:choose>
      <xsl:when test="not(position()=last())">
       <xsl:text>, </xsl:text>
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa; </xsl:text>
       </xsl:if>
      </xsl:when>
      <xsl:otherwise>) </xsl:otherwise>
     </xsl:choose>
    </xsl:for-each>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>
 <xsl:template match="SECOBJS">
  <!-- *******************************************************************
Template: SECOBJS
******************************************************************** -->
  <xsl:param name="IndexFullName" select="''"/>
  <xsl:param name="ShardPartitionName" select="''"/>
  <xsl:for-each select="SECOBJS_ITEM">
   <xsl:if test="position()=1">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_EXPORT_EXTENSION.BEGIN_IMPORT_DOMAIN_INDEX</xsl:with-param>
     <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
    </xsl:call-template>
    <xsl:text>BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>SYS.DBMS_EXPORT_EXTENSION.BEGIN_IMPORT_DOMAIN_INDEX('</xsl:text>
    <xsl:call-template name="EnQuote">
     <xsl:with-param name="String" select="../../SCHEMA_OBJ/OWNER_NAME"/>
    </xsl:call-template>
    <xsl:text>','</xsl:text>
    <xsl:call-template name="EnQuote">
     <xsl:with-param name="String" select="$IndexFullName"/>
    </xsl:call-template>
    <xsl:text>'); </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/
</xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_EXPORT_EXTENSION.INSERT_SECOBJ</xsl:with-param>
    <xsl:with-param name="ObjectType">INDEX</xsl:with-param>
   </xsl:call-template>
   <xsl:text>BEGIN </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>SYS.DBMS_EXPORT_EXTENSION.INSERT_SECOBJ('</xsl:text>
   <xsl:call-template name="EnQuote">
    <xsl:with-param name="String" select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:call-template>
   <xsl:text>','</xsl:text>
   <xsl:call-template name="EnQuote">
    <xsl:with-param name="String">
     <xsl:choose>
      <xsl:when test="string-length($UNIQUE_NAME) > 0">
       <xsl:text>KU$_</xsl:text>
       <xsl:value-of select="$UNIQUE_NAME"/>
       <xsl:text>_</xsl:text>
       <xsl:value-of select="SCHEMA_OBJ/OBJ_NUM"/>
       <xsl:text>_</xsl:text>
       <xsl:value-of select="$ShardPartitionName"/>
       <xsl:text>_</xsl:text>
       <xsl:value-of select="SCHEMA_OBJ/NAME"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="SCHEMA_OBJ/NAME"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
   </xsl:call-template>
   <xsl:text>'); </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>END;</xsl:text>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>
/
</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
