SET SERVEROUTPUT ON

REM Apply script for patch 30978304/24114976
DEFINE logfiledir = &1

COLUMN sqlpatch_logfile NEW_VALUE full_logfile

SELECT '&logfiledir' || '30978304_apply_' ||
       CASE WHEN (sys_context('userenv', 'cdb_name') IS NULL) 
            THEN name
            ELSE name || '_' || replace(sys_context('userenv', 'con_name'), '$')
             END || TO_CHAR(systimestamp, '_YYYYMonDD_HH24_MI_SS',
             'NLS_DATE_LANGUAGE=AMERICAN') ||'.log' AS sqlpatch_logfile
  FROM v$database;

SPOOL &full_logfile

SET PAGESIZE 0
SELECT 'Starting apply for patch 30978304/24114976 on ' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

BEGIN
    dbms_sqlpatch.patch_initialize(p_patch_id      => 30978304,
                                   p_patch_uid     => 24114976,
                                   p_logfile       => '&full_logfile');
END;
/


COLUMN install_file NEW_VALUE sql_script


ALTER SESSION SET CURRENT_SCHEMA = SYS;

SET PAGESIZE 0
SELECT 'Calling rdbms/admin/dbmsplts.sql on ' || SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

PROMPT IGNORABLE ERRORS: NONE

SELECT dbms_sqlpatch.install_file('rdbms/admin/dbmsplts.sql') AS install_file
  FROM dual;
@@&sql_script


ALTER SESSION SET CURRENT_SCHEMA = SYS;

SET PAGESIZE 0
SELECT 'Calling rdbms/admin/prvtplts.plb on ' || SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

PROMPT IGNORABLE ERRORS: NONE

SELECT dbms_sqlpatch.install_file('rdbms/admin/prvtplts.plb') AS install_file
  FROM dual;
@@&sql_script


ALTER SESSION SET CURRENT_SCHEMA = SYS;

SET PAGESIZE 0
SELECT 'Calling rdbms/admin/dpload.sql on ' || SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

PROMPT IGNORABLE ERRORS: ORA-04043,ORA-00942,ORA-01921,ORA-00955,ORA-14452

SELECT dbms_sqlpatch.install_file('rdbms/admin/dpload.sql') AS install_file
  FROM dual;
@@&sql_script



BEGIN dbms_sqlpatch.patch_finalize; END;
/

SET PAGESIZE 0
SELECT 'Finished apply for patch 30978304/24114976 on' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

SPOOL off

