Rem
Rem $Header: rdbms/admin/catmet2.sql /st_rdbms_19/1 2019/08/30 08:48:12 jjanosik Exp $
Rem
Rem catmet2.sql
Rem
Rem Copyright (c) 2004, 2019, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      catmet2.sql - Creates heterogeneous types for Data Pump's mdapi
Rem
Rem    DESCRIPTION
Rem      Creates heterogeneous type definitions for
Rem        TABLE_EXPORT
Rem        SCHEMA_EXPORT
Rem        DATABASE_EXPORT
Rem        TRANSPORTABLE_EXPORT
Rem      Also loads xsl stylesheets
Rem      All this must be delayed until the packages have been built.
Rem
Rem    NOTES
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/catmet2.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/catmet2.sql
Rem SQL_PHASE: CATMET2
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catdph.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      08/14/19 - Backport
Rem                           apfwkr_blr_backport_29989845_19.3.0.0.190416dbru
Rem                           from st_rdbms_19.3.0.0.0dbru
Rem    apfwkr      07/31/19 - Backport sdavidso_bug-29989845 from main
Rem    sdavidso    07/01/19 - bug 29989845 check for XBD being VALID or UPGRADED
Rem    surman      01/23/14 - 13922626: Update SQL metadata
Rem    mjangir     09/21/12 - bug 14658090: run catmetx to enable diffing code
Rem    lbarton     06/22/04 - Bug 3695154: obsolete initmeta.sql 
Rem    lbarton     04/27/04 - lbarton_bug-3334702
Rem    lbarton     01/28/04 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

-- create the types

exec dbms_metadata_build.set_debug(false);
exec DBMS_METADATA_DPBUILD.create_table_export;
exec DBMS_METADATA_DPBUILD.create_schema_export;
exec DBMS_METADATA_DPBUILD.create_database_export;
exec DBMS_METADATA_DPBUILD.create_transportable_export;

-- load XSL stylesheets

exec SYS.DBMS_METADATA_UTIL.LOAD_STYLESHEETS;

-- Bug 6603832: Run catmetx.sql if XDB is installed in the database
-- Bug 14658090: Run catmetx.sql to enable the diffing code 
-- Bug 29989845: only run catmetx.sql if XDB is current version and
--                XDB status is VALID(1) or UPGRADED(5)
--   the status check is to avoid errors thrown from XDB view creation
--   if upgrade failed in a way that updated the XDB version, but left if 
--   invalid. In that case, a subsequent re-upgrade of XDB may clear the invalid
--   state -- and will also call catmetx.
COLUMN :xdb_metadata NEW_VALUE xdb_metadata_file NOPRINT
VARIABLE xdb_metadata VARCHAR2(50)

DECLARE
  xdb_version registry$.version%type;
  xdb_status registry$.status%type;
  catalog_version registry$.version%type;
BEGIN
  :xdb_metadata := 'nothing.sql';    -- initialize for not running catmetx.sql
  select version into catalog_version from registry$ where cid = 'CATALOG';
  select version, status into xdb_version, xdb_status 
    from registry$ where cid='XDB';
  IF (xdb_version = catalog_version) AND (xdb_status in (1,5)) THEN
    :xdb_metadata := 'catmetx.sql';
  END IF;
EXCEPTION
  WHEN no_data_found THEN NULL;  --  XDB not loaded
END;
/

SELECT :xdb_metadata FROM DUAL;
@@&xdb_metadata_file



@?/rdbms/admin/sqlsessend.sql
