@@?/rdbms/admin/sqlsessstart.sql
CREATE OR REPLACE TYPE kupc$_LogEntries FORCE AS VARRAY(10) OF (ku$_LogEntry)
PERSISTABLE -- Part of kupc$_JobInfo
/
grant execute on kupc$_LogEntries to public;
CREATE OR REPLACE TYPE kupc$_JobInfo FORCE AUTHID CURRENT_USER IS OBJECT (
        errstat_info   kupc$_LogEntries,
        CONSTRUCTOR FUNCTION kupc$_JobInfo(
                                logLine IN ku$_LogLine
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_JobInfo(
                                text IN VARCHAR2,
                                errorNumber IN NUMBER DEFAULT NULL
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_JobInfo(
                                logEntry IN ku$_LogEntry
                                ) RETURN SELF AS RESULT,
        STATIC FUNCTION createJobInfo(
                                logLine IN ku$_LogLine
                                ) RETURN kupc$_JobInfo,
        STATIC FUNCTION createJobInfo(
                                text IN VARCHAR2,
                                errorNumber IN NUMBER DEFAULT NULL
                                ) RETURN kupc$_JobInfo,
        STATIC FUNCTION createJobInfo(
                                logEntry IN ku$_LogEntry
                                ) RETURN kupc$_JobInfo,
        MEMBER PROCEDURE addLogEntry(
                                logEntry IN ku$_LogEntry DEFAULT NULL
                                ),
        MEMBER PROCEDURE addLine(
                                logLine IN ku$_LogLine
                                ),
        MEMBER PROCEDURE addLine(
                                text IN VARCHAR2,
                                errorNumber IN NUMBER DEFAULT NULL
                                ),
        MEMBER PROCEDURE addError(
                                errorNumber IN NUMBER,
                                param1 IN VARCHAR2 DEFAULT '',
                                param2 IN VARCHAR2 DEFAULT '',
                                param3 IN VARCHAR2 DEFAULT '',
                                param4 IN VARCHAR2 DEFAULT '',
                                param5 IN VARCHAR2 DEFAULT '',
                                param6 IN VARCHAR2 DEFAULT '',
                                param7 IN VARCHAR2 DEFAULT '',
                                param8 IN VARCHAR2 DEFAULT ''
                                ),
        MEMBER FUNCTION format RETURN ku$_LogEntry,
        MEMBER PROCEDURE printJobInfo,
        MEMBER PROCEDURE addTimeStamp
        )
PERSISTABLE -- Part of kupc$_mastererror, kupc$_masterjobinfo, etc
/
grant execute on kupc$_JobInfo to public;
CREATE OR REPLACE TYPE kupc$_LobPieces FORCE 
AS VARRAY(4000) OF (VARCHAR2(4000))
PERSISTABLE -- Part of kupc$_data_filter, kupc$_metadata_filter
/
grant execute on kupc$_LobPieces to public;
CREATE OR REPLACE TYPE kupc$_message FORCE AS OBJECT (
        msgtype                 NUMBER,
        requestid               VARCHAR2(128),
        MEMBER FUNCTION isDatagram RETURN BOOLEAN,
        MEMBER FUNCTION isRequest  RETURN BOOLEAN,
        MEMBER FUNCTION isResponse RETURN BOOLEAN
        ) NOT FINAL
PERSISTABLE -- ***Root of DP persistable types***: Part of AQ messaging table
/
grant execute on kupc$_message to public;
CREATE OR REPLACE TYPE kupc$_master_msg FORCE UNDER kupc$_message (
        parallel                NUMBER,
        last_error              NUMBER,
        error_count             NUMBER,
        debug_flags             NUMBER,
        mcp_queue_type          NUMBER
        ) NOT FINAL NOT INSTANTIABLE
/
grant execute on kupc$_master_msg to public;
CREATE OR REPLACE TYPE kupc$_shadow_msg FORCE UNDER kupc$_message (
        handle                  NUMBER
        ) NOT FINAL NOT INSTANTIABLE
/
grant execute on kupc$_shadow_msg to public;
CREATE OR REPLACE TYPE kupc$_worker_msg FORCE UNDER kupc$_message (
        id                      NUMBER
        ) NOT FINAL NOT INSTANTIABLE
/
grant execute on kupc$_worker_msg to public;
CREATE OR REPLACE TYPE kupc$_add_device FORCE UNDER kupc$_shadow_msg (
        devicename                VARCHAR2(4000),
        volumesize                NUMBER,
        CONSTRUCTOR FUNCTION kupc$_add_device(
                                dn  VARCHAR2,
                                vs  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_add_device(
                                qh  NUMBER,
                                dn  VARCHAR2,
                                vs  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_add_device to public;
CREATE OR REPLACE TYPE kupc$_add_file FORCE UNDER kupc$_shadow_msg (
        filename                VARCHAR2(4000),
        directory               VARCHAR2(4000),
        filesize                NUMBER,
        filetype                NUMBER,
        reusefile               NUMBER,
        CONSTRUCTOR FUNCTION kupc$_add_file(
                                fn  VARCHAR2,
                                dr  VARCHAR2,
                                fs  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_add_file(
                                qh  NUMBER,
                                fn  VARCHAR2,
                                dr  VARCHAR2,
                                fs  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_add_file(
                                fn  VARCHAR2,
                                dr  VARCHAR2,
                                fs  NUMBER,
                                ft  NUMBER,
                                rf  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_add_file(
                                qh  NUMBER,
                                fn  VARCHAR2,
                                dr  VARCHAR2,
                                fs  NUMBER,
                                ft  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_add_file to public;
CREATE OR REPLACE TYPE kupc$_restart FORCE UNDER kupc$_shadow_msg (
        job_name                VARCHAR2(128),
        job_owner               VARCHAR2(128),
        ena_sec_roles           NUMBER,
        CONSTRUCTOR FUNCTION kupc$_restart(
                                jn  VARCHAR2,
                                jo  VARCHAR2,
                                esr NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_restart(
                                qh  NUMBER,
                                jn  VARCHAR2,
                                jo  VARCHAR2,
                                esr NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_restart to public;
CREATE OR REPLACE TYPE kupc$_data_filter FORCE UNDER kupc$_shadow_msg (
        filter_name                VARCHAR2(30),
        filter_value_t             VARCHAR2(4000),
        filter_value_n             NUMBER,
        filter_value_l             kupc$_LobPieces,
        table_name                 VARCHAR2(128),
        schema_name                VARCHAR2(128),
        CONSTRUCTOR FUNCTION kupc$_data_filter(
                                fn   VARCHAR2,
                                fvt  VARCHAR2,
                                tn   VARCHAR2,
                                sn   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_data_filter(
                                fn   VARCHAR2,
                                fvn  NUMBER,
                                tn   VARCHAR2,
                                sn   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_data_filter(
                                fn   VARCHAR2,
                                fvl  CLOB,
                                tn   VARCHAR2,
                                sn   VARCHAR2
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_data_filter to public;
CREATE OR REPLACE TYPE kupc$_data_remap FORCE UNDER kupc$_shadow_msg (
        remap_name                 VARCHAR2(30),
        remap_table                VARCHAR2(128),
        remap_column               VARCHAR2(128),
        remap_function             VARCHAR2(392),
        remap_schema               VARCHAR2(128),
        remap_flags                NUMBER,
        CONSTRUCTOR FUNCTION kupc$_data_remap(
                                rn   VARCHAR2,
                                rt   VARCHAR2,
                                rc   VARCHAR2,
                                rf   VARCHAR2,
                                rs   VARCHAR2,
                                rfg  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_data_remap to public;
CREATE OR REPLACE TYPE kupc$_log_entry FORCE UNDER kupc$_shadow_msg (
        log_entry_text          VARCHAR2(2000),
        logfile_only            NUMBER,
        CONSTRUCTOR FUNCTION kupc$_log_entry(
                                let  VARCHAR2,
                                lon  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_log_entry(
                                qh   NUMBER,
                                let  VARCHAR2,
                                lon  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_log_entry to public;
CREATE OR REPLACE TYPE kupc$_log_error FORCE UNDER kupc$_shadow_msg (
        log_error_text          VARCHAR2(2000),
        error_number            NUMBER,
        fatal_error             NUMBER,
        logfile_only            NUMBER,
        CONSTRUCTOR FUNCTION kupc$_log_error(
                                let  VARCHAR2,
                                len  NUMBER,
                                lfe  NUMBER,
                                lon  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_log_error(
                                qh   NUMBER,
                                let  VARCHAR2,
                                len  NUMBER,
                                lfe  NUMBER,
                                lon  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_log_error to public;
CREATE OR REPLACE TYPE kupc$_metadata_filter FORCE UNDER kupc$_shadow_msg (
        filter_name                VARCHAR2(30),
        filter_value               VARCHAR2(4000),
        clob_value                 kupc$_LobPieces,
        object_path                VARCHAR2(200),
        CONSTRUCTOR FUNCTION kupc$_metadata_filter(
                                fn  VARCHAR2,
                                fv  VARCHAR2,
                                op  VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_metadata_filter(
                                fn  VARCHAR2,
                                lo  CLOB,
                                op  VARCHAR2
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_metadata_filter to public;
CREATE OR REPLACE TYPE kupc$_metadata_transform FORCE UNDER kupc$_shadow_msg (
        transform_name             VARCHAR2(30),
        transform_value_t          VARCHAR2(4000),
        transform_value_n          NUMBER,
        object_type                VARCHAR2(128),
        CONSTRUCTOR FUNCTION kupc$_metadata_transform(
                                tn   VARCHAR2,
                                tvt  VARCHAR2,
                                tvn  NUMBER,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_metadata_transform(
                                qh   NUMBER,
                                tn   VARCHAR2,
                                tvt  VARCHAR2,
                                tvn  NUMBER,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_metadata_transform(
                                tn   VARCHAR2,
                                tvt  VARCHAR2,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_metadata_transform(
                                qh   NUMBER,
                                tn   VARCHAR2,
                                tvt  VARCHAR2,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_metadata_transform(
                                tn   VARCHAR2,
                                tvn  NUMBER,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_metadata_transform(
                                qh   NUMBER,
                                tn   VARCHAR2,
                                tvn  NUMBER,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_metadata_transform to public;
CREATE OR REPLACE TYPE kupc$_metadata_remap FORCE UNDER kupc$_shadow_msg (
        remap_name                VARCHAR2(30),
        remap_old_value           VARCHAR2(4000),
        remap_new_value           VARCHAR2(4000),
        object_type               VARCHAR2(128),
        CONSTRUCTOR FUNCTION kupc$_metadata_remap(
                                rn   VARCHAR2,
                                rov  VARCHAR2,
                                rnv  VARCHAR2,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_metadata_remap(
                                qh   NUMBER,
                                rn   VARCHAR2,
                                rov  VARCHAR2,
                                rnv  VARCHAR2,
                                ot   VARCHAR2
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_metadata_remap to public;
CREATE OR REPLACE TYPE kupc$_open FORCE UNDER kupc$_shadow_msg (
        current_user              VARCHAR2(128),
        operation                 VARCHAR2(30),
        job_mode                  VARCHAR2(30),
        remote_link               VARCHAR2(4000),
        job_name                  VARCHAR2(128),
        version                   VARCHAR2(30),
        compression               NUMBER,
        ena_sec_roles             NUMBER,
        CONSTRUCTOR FUNCTION kupc$_open(
                                cu   VARCHAR2,
                                op   VARCHAR2,
                                jm   VARCHAR2,
                                rl   VARCHAR2,
                                jn   VARCHAR2,
                                vs   VARCHAR2,
                                cp   NUMBER,
                                esr  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_open(
                                qh   NUMBER,
                                cu   VARCHAR2,
                                op   VARCHAR2,
                                jm   VARCHAR2,
                                rl   VARCHAR2,
                                jn   VARCHAR2,
                                vs   VARCHAR2,
                                cp   NUMBER,
                                esr  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_open to public;
CREATE OR REPLACE TYPE kupc$_set_parallel FORCE UNDER kupc$_shadow_msg (
        degree                   NUMBER,
        CONSTRUCTOR FUNCTION kupc$_set_parallel(
                                dg   NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_set_parallel(
                                qh   NUMBER,
                                dg   NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_set_parallel to public;
CREATE OR REPLACE TYPE kupc$_set_parameter FORCE UNDER kupc$_shadow_msg (
                                parameter_name     VARCHAR2(30),
                                parameter_value_t  VARCHAR2(4000),
                                parameter_value_n  NUMBER,
        CONSTRUCTOR FUNCTION kupc$_set_parameter(
                                pn   VARCHAR2,
                                pvt  VARCHAR2,
                                pvn  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_set_parameter(
                                qh   NUMBER,
                                pn   VARCHAR2,
                                pvt  VARCHAR2,
                                pvn  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_set_parameter(
                                pn   VARCHAR2,
                                pvt  VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_set_parameter(
                                qh   NUMBER,
                                pn   VARCHAR2,
                                pvt  VARCHAR2
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_set_parameter(
                                pn   VARCHAR2,
                                pvn  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_set_parameter(
                                qh   NUMBER,
                                pn   VARCHAR2,
                                pvn  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_set_parameter to public;
CREATE OR REPLACE TYPE kupc$_shadow_key_exchange FORCE UNDER kupc$_shadow_msg (
                                public_key    VARCHAR2(256),
                                token         VARCHAR2(4000),
        CONSTRUCTOR FUNCTION kupc$_shadow_key_exchange(
                                pubkey  VARCHAR2,
                                tok     VARCHAR2
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_shadow_key_exchange to public;
CREATE OR REPLACE TYPE kupc$_start_job FORCE UNDER kupc$_shadow_msg (
                                skip_current  NUMBER,
                                cluster_ok    NUMBER,
                                service_name  VARCHAR2(100),
                                abort_step    NUMBER,
        CONSTRUCTOR FUNCTION kupc$_start_job(
                                sc  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_start_job(
                                qh  NUMBER,
                                sc  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_start_job(
                                sc  NUMBER,
                                ab  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_start_job(
                                qh  NUMBER,
                                sc  NUMBER,
                                cl  NUMBER,
                                sn  VARCHAR2,
                                ab  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_start_job to public;
CREATE OR REPLACE TYPE kupc$_stop_job FORCE UNDER kupc$_shadow_msg (
                                immediate_flag  NUMBER,
                                keep_master     NUMBER,
                                delay           NUMBER,
        CONSTRUCTOR FUNCTION kupc$_stop_job(
                                im  NUMBER,
                                km  NUMBER,
                                de  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_stop_job(
                                qh  NUMBER,
                                im  NUMBER,
                                km  NUMBER,
                                de  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_stop_job to public;
CREATE OR REPLACE TYPE kupc$_stop_worker FORCE UNDER kupc$_shadow_msg (
                                worker_id       NUMBER,
                                skip_current    NUMBER,
        CONSTRUCTOR FUNCTION kupc$_stop_worker(
                                wi  NUMBER,
                                sc  NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_stop_worker(
                                qh  NUMBER,
                                wi  NUMBER,
                                sc  NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_stop_worker to public;
CREATE OR REPLACE TYPE kupc$_api_ack FORCE UNDER kupc$_master_msg (
        errnum                   NUMBER,
        error                    kupc$_JobInfo,
        flags                    NUMBER,
        CONSTRUCTOR FUNCTION kupc$_api_ack(
                                en NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_api_ack(
                                en  NUMBER,
                                err kupc$_JobInfo
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_api_ack(
                                en  NUMBER,
                                flg NUMBER
                                ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_api_ack(
                                en  NUMBER,
                                err kupc$_JobInfo,
                                flg NUMBER
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_api_ack to public;
CREATE OR REPLACE TYPE kupc$_disk_file FORCE UNDER kupc$_master_msg (
                                file_number     NUMBER,
                                block_size      NUMBER,
                                flags           NUMBER,
                                allocated_size  NUMBER,
                                file_position   NUMBER,
                                file_max_size   NUMBER,
                                file_name       VARCHAR2(4000),
                                file_type       NUMBER,
                                user_directory  VARCHAR2(4000),
        CONSTRUCTOR FUNCTION kupc$_disk_file(
                                fno  NUMBER,
                                bsz  NUMBER,
                                flg  NUMBER,
                                asz  NUMBER,
                                fpo  NUMBER,
                                msz  NUMBER,
                                fnm  VARCHAR2,
                                typ  NUMBER,
                                dir  VARCHAR2
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_disk_file to public;
CREATE OR REPLACE TYPE kupc$_master_key_exchange FORCE UNDER kupc$_master_msg (
                                public_key      VARCHAR2(256),
                                key_digest      VARCHAR2(64),
        CONSTRUCTOR FUNCTION kupc$_master_key_exchange(
                                pubkey  VARCHAR2,
                                digest  VARCHAR2
                                ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_master_key_exchange to public; 
CREATE OR REPLACE TYPE kupc$_sequential_file FORCE UNDER kupc$_master_msg (
                                block_size      NUMBER,
                                flags           NUMBER,
                                allocated_size  NUMBER,
                                file_max_size   NUMBER,
                                file_name       VARCHAR2(4000),
        CONSTRUCTOR FUNCTION kupc$_sequential_file(
                                bsz  NUMBER,
                                flg  NUMBER,
                                asz  NUMBER,
                                msz  NUMBER,
                                fnm  VARCHAR2
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_sequential_file to public;
CREATE OR REPLACE TYPE kupc$_release_files FORCE UNDER kupc$_master_msg (
                                unused        NUMBER,
        CONSTRUCTOR FUNCTION kupc$_release_files
                               RETURN SELF AS RESULT
        )
/
grant execute on kupc$_release_files to public;
CREATE OR REPLACE TYPE kupc$_unload_metadata FORCE UNDER kupc$_master_msg (
                                flags          NUMBER,
                                degree         NUMBER,
                                start_seqno    NUMBER,
                                end_seqno      NUMBER,
                                md_worker      NUMBER,
        CONSTRUCTOR FUNCTION kupc$_unload_metadata(
                                flg  NUMBER,
                                deg  NUMBER,
                                ssq  NUMBER,
                                esq  NUMBER,
                                mdw  NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_unload_metadata to public;
CREATE OR REPLACE TYPE kupc$_unload_data FORCE UNDER kupc$_master_msg (
                                start_process_order  NUMBER,
                                end_process_order    NUMBER,
                                datasize             NUMBER,
                                method               NUMBER,
                                creation_level       NUMBER,
                                seqno                NUMBER,
        CONSTRUCTOR FUNCTION kupc$_unload_data(
                                spo NUMBER,
                                epo NUMBER,
                                ds  NUMBER,
                                md  NUMBER,
                                pa  NUMBER,
                                lvl NUMBER,
                                seq NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_unload_data to public;
CREATE OR REPLACE TYPE kupc$_load_metadata FORCE UNDER kupc$_master_msg (
                                flags         NUMBER,
                                degree        NUMBER,
                                start_row     NUMBER,
                                end_row       NUMBER,
                                md_worker     NUMBER,
        CONSTRUCTOR FUNCTION kupc$_load_metadata(
                                flg  NUMBER,
                                deg  NUMBER,
                                sro  NUMBER,
                                ero  NUMBER,
                                mdw  NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_load_metadata to public;
CREATE OR REPLACE TYPE kupc$_load_data FORCE UNDER kupc$_master_msg (
                                start_process_order  NUMBER,
                                end_process_order    NUMBER,
                                datasize             NUMBER,
                                method               NUMBER,
                                creation_level       NUMBER,
                                flags                NUMBER,
        CONSTRUCTOR FUNCTION kupc$_load_data(
                                spo NUMBER,
                                epo NUMBER,
                                ds  NUMBER,
                                md  NUMBER,
                                pa  NUMBER,
                                lvl NUMBER,
                                flg NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_load_data to public;
CREATE OR REPLACE TYPE kupc$_estimate_job FORCE UNDER kupc$_master_msg (
                                md_worker NUMBER,
        CONSTRUCTOR FUNCTION kupc$_estimate_job (mdw NUMBER)
                               RETURN SELF AS RESULT
        )
/
grant execute on kupc$_estimate_job to public;
CREATE OR REPLACE TYPE kupc$_recomp FORCE UNDER kupc$_master_msg (
                               md_worker NUMBER,
        CONSTRUCTOR FUNCTION kupc$_recomp (mdw NUMBER)
                               RETURN SELF AS RESULT
        )
/
grant execute on kupc$_recomp to public;
CREATE OR REPLACE TYPE kupc$_sql_file_job FORCE UNDER kupc$_master_msg (
                                file_path     VARCHAR2(4000),
                                file_name     VARCHAR2(2000),
                                restart       NUMBER,       
        CONSTRUCTOR FUNCTION kupc$_sql_file_job(
                                fp  VARCHAR2,
                                fn  VARCHAR2,
                                rst NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_sql_file_job to public;
CREATE OR REPLACE TYPE kupc$_prepare_data FORCE UNDER kupc$_master_msg (
                                seqno          NUMBER,
                                path           VARCHAR2(200),
                                restart        NUMBER,
        CONSTRUCTOR FUNCTION kupc$_prepare_data(
                                sq   NUMBER,
                                pa   VARCHAR2,
                                rst  NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_prepare_data to public;
CREATE OR REPLACE TYPE kupc$_restore_logging FORCE UNDER kupc$_master_msg (
                                seqno          NUMBER,
        CONSTRUCTOR FUNCTION kupc$_restore_logging(
                                sq   NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_restore_logging to public;
CREATE OR REPLACE TYPE kupc$_fixup_virtual_column FORCE UNDER kupc$_master_msg (
                                seqno          NUMBER,
        CONSTRUCTOR FUNCTION kupc$_fixup_virtual_column(
                                sq   NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_fixup_virtual_column to public;
CREATE OR REPLACE TYPE kupc$_complete_imp_object FORCE UNDER kupc$_master_msg (
                                old_seqno      NUMBER,
                                new_seqno      NUMBER,
                                restart        NUMBER,
        CONSTRUCTOR FUNCTION kupc$_complete_imp_object(
                                osn  NUMBER,
                                nsn  NUMBER,
                                rst  NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_complete_imp_object  to public;
CREATE OR REPLACE TYPE kupc$_exit FORCE UNDER kupc$_master_msg (
                                unused        NUMBER,
        CONSTRUCTOR FUNCTION kupc$_exit
                               RETURN SELF AS RESULT
        )
/
grant execute on kupc$_exit to public;
CREATE OR REPLACE TYPE kupc$_post_mt_init FORCE UNDER kupc$_master_msg (
                                metadata_worker    NUMBER,
                                restarting         NUMBER,
        CONSTRUCTOR FUNCTION kupc$_post_mt_init (
                                mdw  NUMBER,
                                rs   NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_post_mt_init to public;
CREATE OR REPLACE TYPE kupc$_mastererror FORCE UNDER kupc$_master_msg (
                                flags        NUMBER,
                                error        kupc$_JobInfo,
        CONSTRUCTOR FUNCTION kupc$_mastererror(
                                err  kupc$_JobInfo
                               ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_mastererror(
                                flg  NUMBER,
                                err  kupc$_JobInfo
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_mastererror to public;
CREATE OR REPLACE TYPE kupc$_masterjobinfo FORCE UNDER kupc$_master_msg (
                                flags          NUMBER,
                                jobinfo        kupc$_JobInfo,
        CONSTRUCTOR FUNCTION kupc$_masterjobinfo(
                                info  kupc$_JobInfo
                               ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_masterjobinfo(
                                flg   NUMBER,
                                info  kupc$_JobInfo
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_masterjobinfo to public;
CREATE OR REPLACE TYPE SYS.kupc$_mdFilePiece FORCE AS OBJECT
(
   dump_fileid     NUMBER,
   dump_pos        NUMBER,
   dump_len        NUMBER,
   dump_alloc      NUMBER,
   dump_off        NUMBER,
   dump_name       VARCHAR2(4000),
   dump_cred       VARCHAR2(4000),
   CONSTRUCTOR FUNCTION kupc$_mdFilePiece RETURN SELF AS RESULT,
   CONSTRUCTOR FUNCTION kupc$_mdFilePiece (
                                fid      NUMBER,
                                pos      NUMBER,
                                len      NUMBER,
                                alc      NUMBER
                               ) RETURN SELF AS RESULT
)
NOT PERSISTABLE
/
grant execute on kupc$_mdFilePiece to public;
CREATE OR REPLACE TYPE SYS.kupc$_mdFilePieceList FORCE
AS TABLE OF (SYS.kupc$_mdFilePiece)
NOT PERSISTABLE
/
grant execute on kupc$_mdFilePieceList to public;
CREATE OR REPLACE TYPE SYS.kupc$_mdReplOffsets FORCE AS OBJECT
(
   offset          NUMBER,
   CONSTRUCTOR FUNCTION kupc$_mdReplOffsets RETURN SELF AS RESULT,
   CONSTRUCTOR FUNCTION kupc$_mdReplOffsets (
                                off      NUMBER
                               ) RETURN SELF AS RESULT
)
NOT PERSISTABLE
/
grant execute on kupc$_mdReplOffsets to public;
CREATE OR REPLACE TYPE SYS.kupc$_mdReplOffsetsList FORCE
AS TABLE OF (SYS.kupc$_mdReplOffsets)
NOT PERSISTABLE
/
grant execute on kupc$_mdReplOffsetsList to public;
CREATE OR REPLACE TYPE kupc$_fileInfo FORCE AS OBJECT
(
   fileNumber         NUMBER,         -- Assigned file-number
   mediaType          NUMBER,         -- 0=disk file, 1=pipe, 2=tape, 3=uridisk
   version            NUMBER,         -- Dump file version (for import)
   directory          VARCHAR2(4000), -- Directory spec
   fileName           VARCHAR2(4000), -- User filename
   fileSpec           VARCHAR2(4000), -- Full file spec
   guid               RAW(16),        -- Holds guid from dmphdr during import
   maxFileSize        NUMBER,         -- Max size to use or 0 for unlimited
   flags              NUMBER,         -- FLAGS attribute for a DISK_FILE msg
   allocSize          NUMBER,         -- Tracks most current allocation size
   filePos            NUMBER,         -- Tracks most current file position
   blockSize          NUMBER,         -- Used only during import as a check
   charsetID          NUMBER,         -- Used only during import for lobs
   mdEncoding         NUMBER,         -- Used only during import for lobs
   reservedTo         NUMBER,         -- The ID of the proc using the file
   sid                NUMBER,         -- ID of slave if parallel
   used               NUMBER(1),      -- 1 if file was used, else 0
   reserved           NUMBER(1),      -- 1 when file is inuse, else 0
   usable             NUMBER(1),      -- 1 if file is good, else 0
   verified           NUMBER(1),      -- 1 if file verified at import, else 0
   hasMstTbl          NUMBER(1),      -- 1 if file contains the msttbl, else 0
   CONSTRUCTOR FUNCTION kupc$_fileInfo RETURN SELF AS RESULT
)
PERSISTABLE -- Part of kupc$_fileList
/
grant execute on kupc$_fileInfo to public;
CREATE OR REPLACE TYPE kupc$_fileList FORCE AS TABLE OF (kupc$_fileInfo)
PERSISTABLE -- Part of kupc$_file_list
/
grant execute on kupc$_fileList to public;
CREATE OR REPLACE TYPE kupc$_file_list FORCE UNDER kupc$_master_msg (
                            fileList     kupc$_fileList,
        CONSTRUCTOR FUNCTION kupc$_file_list(
                            flist        kupc$_fileList
                           ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_file_list to public;
CREATE OR REPLACE TYPE kupc$_encoded_pwd FORCE UNDER kupc$_master_msg (
                                encoded_pwd RAW(2000),
                                encoded_pwd_len NUMBER,
        CONSTRUCTOR FUNCTION kupc$_encoded_pwd(
                                encPwd    RAW,
                                encPwdLen NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_encoded_pwd to public;
CREATE OR REPLACE TYPE kupc$_get_work FORCE UNDER kupc$_worker_msg (
                                dummy         NUMBER,
        CONSTRUCTOR FUNCTION kupc$_get_work RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_get_work(
                                wid  NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_get_work to public;
CREATE OR REPLACE TYPE kupc$_worker_file FORCE UNDER kupc$_worker_msg (
                                sid           NUMBER,
                                flags         NUMBER,
                                minimum_size  NUMBER,
                                used_byte     NUMBER,
                                alloc_size    NUMBER,
                                file_number   NUMBER,
        CONSTRUCTOR FUNCTION kupc$_worker_file(
                                wid      NUMBER,
                                psi      NUMBER,
                                flg      NUMBER,
                                msz      NUMBER,
                                usb      NUMBER,
                                asz      NUMBER,
                                fno      NUMBER
                               ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_worker_file(
                                flg      NUMBER,
                                msz      NUMBER
                               ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_worker_file(
                                wid      NUMBER,
                                psi      NUMBER,
                                flg      NUMBER,
                                usb      NUMBER,
                                asz      NUMBER,
                                fno      NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_worker_file to public;
CREATE OR REPLACE TYPE kupc$_device_ident FORCE UNDER kupc$_worker_msg (
                                flags         NUMBER,
                                file_name     VARCHAR2(4000),
                                file_number   NUMBER,
        CONSTRUCTOR FUNCTION kupc$_device_ident(
                                flg      NUMBER,
                                fnm      VARCHAR2,
                                fno      NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_device_ident to public;
CREATE OR REPLACE TYPE kupc$_bad_file FORCE UNDER kupc$_worker_msg (
                                error         ku$_LogEntry,
                                bad_row       CLOB,
        CONSTRUCTOR FUNCTION kupc$_bad_file(
                                err      ku$_LogEntry,
                                bro      CLOB
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_bad_file to public;
CREATE OR REPLACE TYPE kupc$_table_data FORCE AS OBJECT (
                                process_order  NUMBER,
                                creation_level NUMBER,
                                degree         NUMBER,
                                datasize       NUMBER,
                                method         NUMBER,
                                seqno          NUMBER
        )
PERSISTABLE -- Part of kupc$_table_datas
/
grant execute on kupc$_table_data to public;
CREATE OR REPLACE TYPE kupc$_table_datas FORCE
AS VARRAY(1000) OF (kupc$_table_data)
PERSISTABLE -- Part of kupc$_table_data_array
/
grant execute on kupc$_table_datas to public;
CREATE OR REPLACE TYPE kupc$_table_data_array FORCE UNDER kupc$_worker_msg (
                                table_datas   kupc$_table_datas,
        CONSTRUCTOR FUNCTION kupc$_table_data_array(
                                tds      kupc$_table_datas
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_table_data_array to public;
CREATE OR REPLACE TYPE kupc$_type_comp_ready FORCE UNDER kupc$_worker_msg (
                               seqno     NUMBER,
        CONSTRUCTOR FUNCTION kupc$_type_comp_ready(
                                sn       NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_type_comp_ready to public;
CREATE OR REPLACE TYPE kupc$_worker_log_entry FORCE UNDER kupc$_worker_msg (
                                wip           ku$_LogEntry,
        CONSTRUCTOR FUNCTION kupc$_worker_log_entry(
                                log      ku$_LogEntry
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_worker_log_entry to public;
CREATE OR REPLACE TYPE kupc$_workererror FORCE UNDER kupc$_worker_msg (
                                error         kupc$_JobInfo,
                                errcnt        NUMBER,
                                workerid      NUMBER,
                                last_msg      NUMBER,
        CONSTRUCTOR FUNCTION kupc$_workererror(
                                err      kupc$_JobInfo,
                                ecnt     NUMBER,
                                wid      NUMBER,
                                lstmsg   NUMBER
                               ) RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_workererror(
                                err      kupc$_JobInfo,
                                ecnt     NUMBER,
                                lstmsg   NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_workererror to public;
CREATE OR REPLACE TYPE kupc$_worker_exit FORCE UNDER kupc$_worker_msg (
                                process_number       NUMBER,
        CONSTRUCTOR FUNCTION kupc$_worker_exit(
                                pid      NUMBER
                               ) RETURN SELF AS RESULT
        )
/
grant execute on kupc$_worker_exit to public;
CREATE OR REPLACE TYPE kupc$_worker_file_list FORCE UNDER kupc$_worker_msg (
                             dummy NUMBER,
        CONSTRUCTOR FUNCTION kupc$_worker_file_list 
                             RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_worker_file_list (wid NUMBER)
                             RETURN SELF AS RESULT
        )
/
grant execute on kupc$_worker_file_list to public;
CREATE OR REPLACE TYPE kupc$_worker_get_pwd FORCE UNDER kupc$_worker_msg (
                             dummy NUMBER,
        CONSTRUCTOR FUNCTION kupc$_worker_get_pwd
                             RETURN SELF AS RESULT,
        CONSTRUCTOR FUNCTION kupc$_worker_get_pwd (wid NUMBER)
                             RETURN SELF AS RESULT
        )
/
grant execute on kupc$_worker_get_pwd to public;
CREATE OR REPLACE TYPE kupc$_mt_info FORCE AS OBJECT (
    version     VARCHAR2(30),
    owner_name  VARCHAR2(128),
    table_name  VARCHAR2(128))
NOT PERSISTABLE
/
CREATE OR REPLACE TYPE kupc$_mt_info_list FORCE IS TABLE OF (kupc$_mt_info)
NOT PERSISTABLE
/
CREATE OR REPLACE TYPE kupc$_mt_col_info FORCE AS OBJECT (
    col_name    VARCHAR2(128),
    col_type    VARCHAR2(30),
    col_version VARCHAR2(30),
    col_size    NUMBER)
NOT PERSISTABLE
/
CREATE OR REPLACE TYPE kupc$_mt_col_info_list FORCE
IS TABLE OF (kupc$_mt_col_info)
NOT PERSISTABLE
/
CREATE OR REPLACE TYPE kupc$_par_con FORCE AS OBJECT (
   ind1            NUMBER,          /* 1st Parameter number */
   ok_value1       VARCHAR2(200),   /* Ok value for 1st parameter */
   ind2            NUMBER,          /* 2nd Parameter number */
   ok_value2       VARCHAR2(200),   /* Ok value for 2nd parameter */
   ok_mode         VARCHAR2(30))   /* Legal if in using this mode */
NOT PERSISTABLE
/
CREATE OR REPLACE PACKAGE kupcc wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
1d266 5a9d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/
show errors
GRANT EXECUTE ON sys.kupcc TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM kupcc FOR sys.kupcc;
CREATE OR REPLACE FUNCTION sys.kupc$_tab_mt_cols wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
225 144
E8XSTIZ57w7ckHiHuTf2pnf1r4Awgzv3LdxqZ3RAWE6OHHsU05cd0ttQG9z2UgiQ/8t5k9yg
C21nUTQkv1vg4QEmSfixu3KnAFloPq1ATsH43vNklsbOI/CwxNmARD7h/I4EXcrNhl2Y6XYq
n/9gBq/pDFGP+oxs1BypGvIu2wClIeJ/dSfw/QYseTqmiLMN7dCG8o5qliakFuPskWh5+uAt
t6baLhT2r3vB2XtCBDbECrVxTfnQD0lw64sY6u8ZH3dZR4zSjyACIxXKKVt4Ub0AC+t14RPa
eoaHDBdhC2XBXsHk+Ajo8uy++OEWHAIc

/
GRANT EXECUTE ON sys.kupc$_tab_mt_cols TO PUBLIC;
CREATE OR REPLACE TYPE BODY kupc$_message wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
234 113
AcufSQMc4QeP1t8bqOuoIW8bBRcwg+1Kf5kVZ3QCkPjVZVcWjjWxBrixDB44EuqWvmte8z7L
ZueVtbs9YdaPK1L6mZb62cYyAso75e4zz3Gn1+3NRU4NRDXzZ/RjoltYeD729me301bASfK4
hRlYuN6ZjslUnHX2to5nF2eH05iNareA4DsGeTS6ahxKvPLr14nrNvsij7g5Xlba0PoFFayl
x6f0cPCEjBUKvChM0xBsHPuL4dAzJDAmwkC4IqXITroGvNGHtTkH9A==

/
CREATE OR REPLACE TYPE BODY kupc$_add_device wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
2dd 148
03SR98pqf/kmLeLFZkAzJ56v+F4wg1XIACAVfC9A2k7VSHCmPuZr4MX8j9DWohQXpTGnJZXl
5x3gOD6dT9tIPTtWWYFwOv/Q3HLt4gXvWozaU89M0OvOMf4tJFX/xrbnQaYWhIrY6v9UtDAJ
4t822p3q6xagSquEO7jfqaosLqY1VFy9+KN6Gh0dyCBsgwd9dlZ7IL0EE9cOeomK/ZxDbEj2
8u+jGUVS68T+FGRvnZsI+CCQ3Wjvsxun7XZhnIIulcJUjQGtcsN88CD3HtCiRP9VfmW899Ij
mzTSyz2uHJW1oUXTGhPbpOXBFyQZlr8lflhu

/
CREATE OR REPLACE TYPE BODY kupc$_add_file wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
811 1a1
yPeExkb/DuayDeA9GXrF2YfnbSEwg0OJLgwdfy9AAP7qR2sHb2+TlbeVhCKYr4qKn/GOYZzK
KzXSj5W1u8mx6QI8YcocaHbmZUIEm7yCXyAnRDTxsnqd7RmuhlWf/SxPhxypvr2pTVBCnhXq
NnsOpejmU7INdWAbAXfU5ZNtczQh4diI9KyzAZ/Ip/WeO6SmQPHVe+P/N4koRo+JPTs0M/ys
ge1p4qc5mI5jupJd+oEuScNuKOaGxtlRagk2kzFS0aU8bCLrdUyR6kJBchJgqwn6RYvVFCna
idOtAynT3v6IBU69iJdFB1pEsAlWzATYpBWhkXvViW36IJRSXHRgF4ZWMK9pM4dkGFJh3ZqJ
gec8LHLx+btONfik7WcjkWqPieKIco+0Mf34waKDchn7o5hr0g==

/
CREATE OR REPLACE TYPE BODY kupc$_restart wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
374 158
XqMpDFos85A2xF+/DYjqw+tLy0cwg0P3rvbhNXSVALuwha/WFWZ9JsMjdVjw4p94jKHUBt4W
Y7CHGD27u4osL5bya1DWx+e2m+9d7bD4sqyBlRy83JosajDO5K28LEpwFB24QaKtV4F0bWfc
6kGPKn5ofGUYqzzMUUidKvuKdJglpVadrviaUBZ0jidtzx+kHYw5Gy/Yb6FMJ2zDgymgU3HM
mFGnY99Kep2ge1UasYj4r3oe4qD3WVXg036bhUo8ia5OKYrezzXk/agPf/kYNWXMUOkzlPJq
bABVGpgNOu+UTorQUbSnUAWNJJF+Y2tRJ2t5Oq413zK4OTeFYS0=

/
CREATE OR REPLACE TYPE BODY kupc$_data_filter wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
87b 288
cAIvCTUdz6FIfmpyGkqW2sjY7S0wg82JAK5qfC9AWPjVSHBad00nmR1RfFdK62BX3AFPmVnz
BoTmfMrD+SQXxjt2CGw5omx9UNu/ZLv/rhk2lpzhm+hTRgecsB5zM4snED0ZVSTiIE83WK+m
qXiXDmF2/bJjXHYKYK9YTJtzYXCFg8LxFvXml3KqY1GdlOvPr9Ih+KO8FbuFCBI9Lla1CZCs
bxEN4e+RoVQR3tiiW+fKH07yOtMNWIxqQs/8OqXM27Cy+ljqQHXgDer9E7YGej5c3/rL1N6u
oOAlGG8SRZTxpbh6P+rlbsOTPpr6+j/Lk9GVE39Q8H9YHAIGQJai1xlNWQ8988D+5pQDDyrL
KY07x2u1edZPMK/4RhFzXBNa/GITz5wu4coCnsm5zmLMBw3Wer2v8rizm9TFX/GGFr6QSfS8
qyIL4fZm8zyvB8wWvf3FXKJqiuPWmG6uSPTMU4X2htx87JkaUHYf0jGJ3mlBlsU+ylIhrtxV
p44EpNH0oUE2Z++TPZToyhPJiBwXxiG5JZDbDYUboleMl+4h/f/vUjcZTkxQLRrhE29HcA9B
yMpVxWGt0tA8TECPq4HfAq94ExXAUy29Mv4Hzn0Cu6tycKXrlnPdTDOH+2OKJes=

/
CREATE OR REPLACE TYPE BODY kupc$_data_remap wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
2c2 16d
Tw/zpHoeTdHstR042cI51+zUo5cwg40lNQxqfI5buHJzjq2KSzXz6pb8pcg06FV8Qj5ClhXc
Y01J80B9/ngpi3FwZeyE7Bokh4+1FQXcmUP8OzC1Ge1HkrHu9n0kmiJAkMjD42qmB9siptqW
7Knd/QcGPvV8Hvb6wv6Dl0g/XbWy0FIjpxw8JepDAf/rV1mG1yHctgrE5nBL8vhtn6g0iy9q
qHnsBBJoCXw0IKklzTnG06ej3FUjMHaMBx6dffhqnT3n/oAWzRE+TbTaKv5U0dkFE5UmOCZZ
SldRATKcPrgbVEcEbjjGB1KeE/UpEI01rDLkyV//PYLCYxrgp53BPuigPFRkGGbX6iQIQvd1


/
CREATE OR REPLACE TYPE BODY kupc$_log_entry wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
2fb 158
UBHxdUM6OJJtBxBqv7eRlkY2y3kwg1X3AK5qfC9AWE7VSH1Q8vOepLp/tP9sSrhyOxDR111r
5nTKZ+dA+RKKRhVgH0V31kPQxjPHZL4P71q6/qXSOmFP28Gxxs6lmwg/pu6ZpgH6A5kYO9Yb
yAb/02gCDeyiCwXj2+JPG7m7ycj7YRU+Ymg0evCweKkV8lHa+v/dqFuAj7Mh+q0uEHx6gwx+
2qviVDqnx2NtBa+HTBJiJxK1uqLkG6eVEbhxyWhSIkPWWTWF3sVjND7BXFzXP1DoggRiWCLW
oT9oBO2bBCaHb7Vvi2Bqf5Cbm/GxrCeCUP0QvJ2Fcz0fH+waNw==

/
CREATE OR REPLACE TYPE BODY kupc$_log_error wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
411 179
+47O0WioK4eQncMkvxEUKVTKG+Ewg83xf64dqI6pkLvqNGuEE3FHMbPU+1PGUvfmmSiBGzkL
diEmvtu1lnY7VaAudnaXZ4/t0B/OMCF+L1N5WzD45DBBlf5V9s+IxlXnR+qmFauu0efCy5F8
rCP2jyJ+21YnBen1/0VCBj8cq72PN61rdbo8SY853UYqgL/hVgh0tD/q+Y1MqYSe/6mAYrfw
oIE1XggVLR7Xw+DN2pfLILsblgaD1TyDxoxBU0krXL6vqFnOojqJKHo+i04UJrwmnC7rVp6j
S8AFdBtibKiIf0zlWVJC2GIS8LOrAFm9mCRpHPGxEYNcgRe1RVy4QPgMtnbsZ3/r/PQZ5ap3
b0K8kuEpx7S2

/
CREATE OR REPLACE TYPE BODY kupc$_metadata_filter wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
571 264
G25AEVzpvve9LpSl88NaiZzbl8Uwg5Ve2dxqfC9dR+rO3ajzzD3hSRxbxlKDqQuAM0XdPuUw
WufIL8W1cpL3ITXjnstsBxQZkPq5R0iPYe4U6pViQvkwmNoRDyw8Cvg9Iz0iIu3YLBm9KvhG
fGyyEdln3gmj+g4J8XExQKSgKlujaQ55k72PezXScuo+vZMJ12/DLAEFs9maDlwDNSBEsKLH
S6PTaun0ewgR2KkOV8FO8pKud8nL/4zrmWR1LrwWSO+PR4wLWSWDgl/Xs1N6PgHf2UqwKeeg
GhVKzAyikFmwpEq9jSBpJZ7zBsWdXXSDQBXgWuqyJdAjn2nBGb5W/zO1Ml/mRCqYdqgrQ9NM
Csfi1u+yfTCfYdfgSwZfxFmTvdZd9ciK+KE5AwiItlWEAQh2xJEv8mZr8ZUOWJC56rR2T/wQ
r3w+m4NTYEnHywQTambzxfCFHulsV6FuF8EfSvHTGNPxaw/Bs0D0TfyeCXYDJwZQrMdUY5bT
I5WeMXR5R6VqLVX/R72d+53lqH10hD/qN6sEarY2GgBRcjdPTxJ20+oRohgQvxoweoqf+woS
sppzP2sRIcEgqg6YuxDhHi5/cA==

/
CREATE OR REPLACE TYPE BODY kupc$_metadata_transform wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
be0 1be
x8ROokJSxI6CdOctvVDUD/VtD0swg82N164VfATUAE7q0t378ZV00nAUHIPiC30zb4PEDFcq
bSwf1qtutZ1MW/N/e6GPDgsHySyd/qH+0t4Pbq5EOGXst8bEnAXiTGiclUzMb2Fxb65kKHLZ
RGtFhOecDsyISgn3tKbG9DbAC+g09oI3IVFaYsWee6fFHr6sT5Y2eF3DCEblOFBfwVP9uV2v
kVlNyVQG1MOrKSLM4fDhUemr2vZojN8+PBt/f0GpnIXSBNUXlmQ0oeTSCqGflV/Pr8b2Dlhk
60CtxpMoqAQ2FziqE9neJ0aVrhFKSgAoarsRTRHB3HNcwvavs+JJRSv3jYVwMC0lTbXERR8v
8Hv4chVWqJ0POwu4Yay3aeMJcnLxPIApSynOckmVCFYR/jP5Cv1TKvC8AjuYle0wLApM8Em7
26tG8g==

/
CREATE OR REPLACE TYPE BODY kupc$_metadata_remap wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
481 185
qvKUG0+muz0u4Q0Ye8XdgUD9aeUwgz0lLgwdfy85cHJzlK3SUBVmBfw1Vhybf80reLd5ZZMp
PlaDt44Yd7Ug3w388i2ONt7LhCIc5ptloNipvYynikN5TncoHj1hQkhhLjBMOxOyhuLGdSF9
hSOh1MImgKHH1oqv6sIsIS/qbjBLDkIq487+OH+n7LqTuNr/SsdeT9sIFEh9DCyVhMk3z8+d
1sCrx/QMwQyDbBRw38b1Ap+CJ+/t7Qy9+tlI5u6Gz/GlSJm+3BlC8wtvHW0xFpiXB5rwPlxN
QimYUHfMh8FCsWZ6HEvOaqtSKPEV+S0SFxbCs86LTtQzcs12aS4jqgV0bWZv0qOp1/9kx/nE
Mp5K5VmfzG72gg2BBqTfrJty

/
CREATE OR REPLACE TYPE BODY kupc$_open wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
68a 1ca
dOY2bNg3mlNXHZDyZi7pkaeJ9xwwg823ACAVfC9A2k7VenypRsUOpOVRy0rHL90iE9ra07cH
5V5jp2O1nZ/hCYP7q70yFdZD0MbBTu0/cxk3Fn6+H7sPB7E45Ho0EOf6HaiJ6TOOicQUp/uN
D7qOBY93fKNbV/KFOujm/Ceh5fEhT3HbOx4CIFmWbvWdfbSZZL4f4ptef3XhfWV0WUnOZtpv
NiIvnjntWWXoPlvNujWZVDstvTgwQwO5cpbwDvwimavQCm011RzzDtA3N2XGa1qdawQmfFgu
yU6wUm1j1hQTT7M42AxHatLjfn7z8GJrDH5ZnMp8PIR39mifqCW9I27cmDdp7E83pYB7Ki+1
8uiLuVyXq5wnwKyJ9pz7AZFp99g5//0mfbBowABOBEtxdOLubUyBvwggHJIgKExy5o3bCXjb
4kVY/G4mwKr+suk08h8=

/
CREATE OR REPLACE TYPE BODY kupc$_set_parallel wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
237 11f
e4FkyXc8QE4g+jaMQjIPttAPgxUwgzvI7cusfI4CkEIY2nwR4M+m9ITelgJUo31y3XcvahQd
CMFzAlH0t2VQ7ujt/tnNrcbflOblVB2xwbj0c+0SzmvtDRCagWdZNmeNISvaJ41AR6EnmWzu
isWrEtY86qK2qGl+gNL+OM9WJY0+/J2KyyGjsGwEjjFNC8+rSYrYFumHhUtRIWjcOUqwDuMc
vJQ6/iG9FoTif8hfcpA6BylK8Wyz7Cse5Ib1nRanASbYLPLcFLY32E5jfy4yTuFp1iPI

/
CREATE OR REPLACE TYPE BODY kupc$_set_parameter wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
9af 18d
xYpaPM1GiTQ3tq8MUG9/TMFRp9Ewg1WNLvbhfy9AEjPqR6/WFQlhLLDyKKGf9WOYA/Zlk6WO
ojMURC0ztXgxYmJv5YmjTfqoT67TGUKIQJwqrNjCbH6HxB5rEt7+SJiDO0EFEJgdODmm5WZq
g8XiIVliPkHqNq5hK4QXyExioBb3zNB6EjQ9jpJgEY2ZEBNui/35qCwiyrryd0nufxGRCr10
b15kd5bwYlOxVlLfsLn0JUdX233uLevY4ighmP6GocY/SLcsapQLY9CQdj2JaBS/Kc7VseMV
UYYdoDhyGbApvyFEgwzNrhLzOEqJLjkXgfb3aoB6t23A/ihH10QB6QfRm1fN+ZA3CBRxVj6U
UvHkZCFTR+W2rqT0GtF2eBTS6iASD7K8

/
CREATE OR REPLACE TYPE BODY kupc$_shadow_key_exchange wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
18a 148
75lg4att3fvmyGY4Y/0DSN7E1kowgwLIJPZqfC+V2vheaI+vObZoJSZr1mxPpAvqZZK327fn
9CaoUDby3vjNEhglYtur2+spc0oSF0AcN/rAqYaxQiyYct6/VxCYhs4e1E9zoPgwLGtQ86ac
5v0BvveexdVT3hqpPDN6nyNcicCGo3Z2SDrlLyobomgk7QE2yFQfGASBiddmYGE15O8Dop6e
8FzhIZ+UQw6wYZC99AQ88FOgMOsNCBIwQu0UBm399Gg9oF/i67+y/jkoAlbuB0Ci7m2DZaME
DE3Irws5ckJBsK+2QJur6b5fZqok5Psw4JO6

/
CREATE OR REPLACE TYPE BODY kupc$_start_job wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
589 18d
UfGaqGBQp+vgERynVR2InfJUnwAwg9cJLdxqfC8BuepoUGuNxYllCX+0H8S9Uv8pkEwmt0R+
fKkO5CRSCXDv5Y70MEuKwbBOmP7/LP0dg0OAMDrPEuzG0Otq+D4inSKs8Yime9Ny++0LtDnm
D3usxSFX0AaU+DC70lFDc+02+xZ3g6XKMr1+z3Dhf58FJxFk09i7PRED1SbVzNn/SUPEv5Cr
NPnMtnKuE0pJXDGidEdAz2aZM1Ml4mNteC7mAxyKqtwXhDrJ36P4+AaYcz3jK/CKw2sWxKR5
D1mFmA8kQO1eI4ML6NKOwX51bTOsRTa4aV8CBhN/tvjE3oD9g+RXRcVrEXJ+agfTLhRcv1wU
fd9n7S+jO+oeVrqH8aqDZLymjExJ2w==

/
CREATE OR REPLACE TYPE BODY kupc$_stop_job wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
332 144
5O82M0MagfQjE2cJkpw6fiozCs4wg5X3nUjWfC/U2k6OeHwUCT1bEYmvtFtXzigtch23Y/UM
QMoNELVwyvbeFFEwS4qYTyJV/qQyYuY46VucmvnV0JoksSJBZElwIh2PPDDAN7cyaTlqoaMd
LhFCHAAx3xx+LYhLndB3pht94VX4ZgV63Z40A219b3YJuDl65cBL388QaSFYVkvxyYlQvFGJ
xsE/IfokuRuGaDEBt6jw5mUVVMUrbKP8JuvKYcyCrn1g975WaS3RlNvYfC63GRHb0brVKQtz
tdKHnY0ynAmC73dapB4XOz5VIHjiB+jy

/
CREATE OR REPLACE TYPE BODY kupc$_stop_worker wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
2bf 134
A3zh9z4DMugcL+KUceZNN2oDS94wgw3I7cusfI5gkBAY2lcR4M+m8B2JnrIwbf4ZQFcyfNx0
q6oGHgw1tklS3csu+IEacyORDyfjecIHkj8iWeSBn3v4xikJLJYvCARnk5GosNvTfnbFf2+o
v2PsMG+6kpcJ4t6DyJqAAaZQeQsuToenPRPN6Rdno3aoS9HfLobJ2eLI4hLYXtbNlLrcbOT1
vkiYCpWAv7V7cQ1d1YKhcNXrAm4TJdWAGszm/+XZmMRqowvCqyhN9pxz4h4kJ1t4E+l1jmJT
2Tm4pIuztu8GjRM=

/
CREATE OR REPLACE TYPE BODY kupc$_disk_file wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
338 199
07toO+hIZz8tRjd8YvsZGNxeO9Ywg43xAK5qfC9AWE7VSH2m0+BwGuC4igxLBpY6HffRHBH3
5WXKqPkk+RZrVhQIL8a/cu17+AAkq0YrA/PcDyxkE1MkP0EGBQhzptsqpsPVwXkOh7p9rFFB
9kSEfPW2iL+EilPdHttznXtj+8PIYoMFk1MymEO4SZJDfJNjfivSVuo+1b2lWVYQZjM/HP6M
k+LXU3M9QWMg3VEoKzeEs2PBoYAfRmQ8xLTHPXcFgSLQ+moLLUEZLjzGxye6U9MmkMnfvoeG
O1D140q7GKKb/l+ZJZjhGLxg41oUCIUbdVm4PN+DCGU3voV9bV8Ull7w5F6M49uD8DTj+WhJ
zSqrdoMhJW9OTdCtjcsqXJoWtYzgBej6mgogqEoa8A==

/
CREATE OR REPLACE TYPE BODY kupc$_sequential_file wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
231 15c
nFv9W0hW7TQWVCV6c7XzzVqElGAwg43Irgwdfy+VALuwdYQongZrgG0HMYqRsi4bKqoYzWzj
fmtUorM/qgP0Vn2vg3bmm4t4ahMf39WsPJ/9MK28AHIlxqU/dock/q4HoAUsOWeapufZIlMW
rDLK720OVmpl4ttWQiPj2zVr3AneRUfSmrCBuqZK6Gy/ENOnRbUkX8FZ3xcxcB1LYEm5s9eu
JeqPFqLGj6HZisWqEHdrYDEJZFMmy5J8QKoS6lGOeJ1RWZrdUVA7YeBYNIOnQHbgjWPUGdDy
3OXFTYL0N0W91L3RXghS5XUslGBedzR5XB6rhhNTuiHXMA/P+3OwMvo=

/
CREATE OR REPLACE TYPE BODY kupc$_release_files wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
d2 df
NyBFrAtyQzgJHXXxtv95pXmSZR4wgxBKr54VfHRAAP4+wLQxW7gwtEX1jvZ77NJLXvMmyrnK
y5qaMp4GlXbmP9O8lmXL5zu7YFMAu8HFAJuJrsfcnB6JFxFU+xGuVqgnCPtZFGI8tnYGDgqO
UDhqdV8yVNy16mf0N6mzWAI0okrcGUpvEgzVj4XtiU+f+D1rxCRK0pOx/JlWggnq1VySi0Sc
LoIG

/
CREATE OR REPLACE TYPE BODY kupc$_unload_metadata wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
252 16d
28hJZ4VZ5IH0xLds2fAHVqK5qLkwg43IACAVfC9n2sHqaN1Q8pT8cXevLZbzFa1qVZPj+hjy
sD/LpbX2xg7ypPL6LzGWch86KUjwUDnE1rGGsU5WpCQZIsYQI6qtX/gIfKz3Od0500MRKnz1
99jRHa/F4s1W6ZuvUyEOqxd3aMn4u7BOAKaVa+m8nRbaNOZvMeQP1PZdr3lym+n+ywQqZTcO
u8C8NI19DUB+LQ8lIeDIhwySxrA+GpC1nljcFVEms1mWldeBxfoBBLCGQlz3TTgurP2eAsF2
je++LBgXe1OgsjTm0SEPSwkgorZlB71e0vkhjA6RhBRiLBzFO3hiHuTQ6euJ/td423LPGg==


/
CREATE OR REPLACE TYPE BODY kupc$_unload_data wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
2d6 191
10euJPAyacTlbtp3wWiipzTo3SUwg43xLgwdfy9AALtkdYQonmZBYhwlkaMfA6GfyQlNnEu0
E1EcirV4LNXnrEzH5/r4IrdkeMDn5/0gy6XAkjCHY+sFHvj1WcYpx+GVTFsO7QtrTZW2fozr
JRJb0H99XBj/IwHxzFHRgjq/ho+vlTjW9RCnlapLQDh/2nVDfmnZk5jEbZPUUslyUepnFvdx
4i0FdoBBwKAJrPu0j+K/MvQ3vwngNJhkvn0TLL4aMXHq8en3GmeH78ebkcjyXEroOn1HIB+d
VcIc/q4y72ou/WkcND6XcOzTjj72s29iTeje5lz5LsJTINw/LcmTlfHIhbHtcaADh2MaEPUJ
XwU64Vd7D9BfC16DmY1SIuRFHvKqCER1M4kD

/
CREATE OR REPLACE TYPE BODY kupc$_load_metadata wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
248 164
2cp7eIwl+Mx+rhboy2Bkc/ebHKMwg43ILUgdqHRA2ppeMIVQWlyNrcxby8+wFqnvC/WXRtwu
sOgnQNJzmYBIfSUUdOcitQQ6t2oca2zHqXJPTvhmkLzGC5KSU1/GCGWsnrKpGyxGjG/gfVGx
wmwomFOxbZGhWF1picxRQccztT0xHN2AsWadaHT9z8p2dbkohu84F0Ctz4KYNmD0iqgOzcI0
z7Kz8j204J2BXpkfIz6DsSC3YHOSgAtFp3guXOiSafExTGwxmYbSV0/FnlFU0+tpESvMPiOC
gm5Ygt7KGagf7IAKd+XKvVjeFSKjEs1paSWO7YkV5SV7C63BLN8uXjOwD2ZPQl4=

/
CREATE OR REPLACE TYPE BODY kupc$_load_data wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
2cf 189
brfkMXFY7J8+QQZyaJvv+dMWvlwwg43xmNzbfC/pJk6U0WGmvagnK45KAL3ztgXsiGSgISvb
n8o1+7XQLDc59LI+UV1oC9rs/a05ae3EgIGbOvk0DGQg2T6Qp9Dp3rmJZRktaSEGobKziFg0
XtB/dUzmZHnCo9IBM/m8VzBDBmgdTE8y7iziAQ0xkM2feH3N0Ry4A9qPU0UXPdXpyvdu4N2o
v/cPrVGgKyMESerEdUKJJY9VEHmVaOSg8TwRDwBvLvHhQh1H+rdExfbAf2JbF6qwpZCnczAj
5cZUSH45QqVhyDHf0yHeot0VrEhHL32bchRGhAybNKMhDhy+yHqNYGkDFMqbgfUfUirV8tSA
SWxTeaDXsHrB0Jq/TL4Pz/tN9vGA

/
CREATE OR REPLACE TYPE BODY kupc$_estimate_job wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
142 11b
3QN4uQM/Tu2cZ7Nh7oSOwk6sF48wgwLQLZ4VfC9AkPiOePVQ6W5iy3kjp4PSZpyZBo7De03j
rIFzeatbSdcvwJq1x8/3c29rfEMc4mTGPoFVAySayxDBlv7vXd/7aUDYS17gBDxKiXdADlK6
jSOgCcS+Dpp14HvDqk9haPvI9pldnVWIfBgL4W0jADB0jDKjUcw3XC6GGDwr0yJLcfBgJ/l5
XSTebwpjmohIyIRCafTDwSt6ZRPzt+t7m/NCAXah52/3YLClYMUDFL3+XbK6JPKc

/
CREATE OR REPLACE TYPE BODY kupc$_recomp wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
12f 10b
9DGe70CPqxeTkdDp0NpVSJ7Ey34wgwJKLZ4VZ3RAkPiOiHt9Zv9vBzPRYmO/vvHZzG5IFtxm
b6/+xLHHPHSoOpu2Ir5K5/Dr6lOdnL5fZAXkz1Zp+OFnrZsVNfQLER0+KaSvL2BcYGBDilMP
hJ3Z/L2prHnItcko3RY3vXrsnypU6ixfkZw5mEFhHzy/8RpynNfppAMM5JvFB/VudiiFPmHy
kScnlvNYVUA+BLc6QFHANxSk3FjJEyHvKeVaef77tgKiEA==

/
CREATE OR REPLACE TYPE BODY kupc$_sql_file_job wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
1c5 148
aLuTyHmFn/ABLGd2IrxPK7ECbKswg43Ir/Idfy9AALteR2tbRD4GswaoEy6fxMlJUmU+0iEO
FhGZO+O7IPFcffrgy6g6iwt1qjD9dKC8BRW5Hs40yHLQ7TS8zQ9dc6U2xd+mgwuR8uwANy5N
QtLnKD59AtuASZ/1YDy87Uf8msY5qfBmABZF7SIghqp+GHR16DxQk4GehbhmRhFu1/NOeBvG
x7Q80u88b16KvoqLubxAPdnrS5teTFwNJQ4wFsKySS89w9pUbmte95UvQ1zJGPq+WOoUg0ld
CVNY3hxflFzxTnPCZRJC/YorLl65bSDMouAd

/
CREATE OR REPLACE TYPE BODY kupc$_exit wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
b7 ca
lbaxUQGfZ8UQZlO1yYadbuEvTpMwg5n0dLhcuJu/9MOF0WJaK/SuO4VWzLh0iwlpuDP+mcu9
njLLCCgJuJmBx8sI0v5epcuyuCv0v/CldPvl3SiscYTm1uSOrEwQaKk54b6vayKoL4yQcVUA
c905zjmYB6lxcAGZ34OTKJH1esN37Jk4y+PN/MHg15VEZoimiH3VHw==

/
CREATE OR REPLACE TYPE BODY kupc$_post_mt_init wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
18b 13c
zs5HXXnaKhi+76m+NSGaEf9dFP4wgwLQLUgVfC9A2sE+SHAWCVwyOTK4bu/CuP+zOlbb9R22
5Q5aRv7GSm13vXpUM6pPqhCnc+NQQEgoJMTZOGucmh4asKHQwYY2G9+m32mO3Cvhahv3lB/n
Yd6gmaSEjqSipK1Ccn1OKvXapvKEbeQI04vnKM5smDZgoVkvsyDC9bzUXWP8xLTa7NVAtAw6
zfwSPMRPtYGBIEXiFhgpXwRVRBlmnEkxvP/AvgRvgBD0rTx3E2gCRzhAPkIPTq0J/dOhiM8A
exggre8yHug++AWkhXCTBA==

/
CREATE OR REPLACE TYPE BODY kupc$_prepare_data wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
18f 130
mU1kQxyH9sEqzx5iScGz5vUqH54wgwLIfyAVfC8C2sHqaN1nYxhr78wHbce983DavxcUG9VR
WUxmw/kkn+EJsNRqt7s6mOsAHjG2w+IianIQNNgGMJhKas2rnQea+2mepobYFluMSmu9PBHB
VorWeAp9WHpllauUsb1ztVpP20AL6eQt5xJZwObf2l1yAW7pDwMfMb9wJd1vRssul3XyvVuQ
6yt3n5+rUokrTsF+neigyU54ec+8p7bsORbCySFiZRIcMpyy0Mdid7qcsikPLkL0z0m6nOn3
gc37e6XD2g==

/
CREATE OR REPLACE TYPE BODY kupc$_restore_logging wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
118 103
lSMsI/kkrBi+qDwhb553c7IqsMYwgwLQf8sVfHTpWMeeKKRw7qbDdCEyjBg83oaRfYn7XJTh
zMOP+RRith0wzsI7SbUgBSrnWP/aUzS5sNuuc4at3O2dSmq4vLK4cPvKKi0q3KN5DrgUeSa9
SuL39HiFOG28JfKNGjw3+UxoOajqFxH5wv18EZCocNgYL2xfisWYRpd8BP9JJyvfvC0Fcmtd
M9WJtaYpWYJhGu/ZzcJUeuDQibDmokzt++yJNSo=

/
CREATE OR REPLACE TYPE BODY kupc$_fixup_virtual_column wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
127 10f
rj4yjeDvab+qbrhlwUV59M5c8VgwgwLQr8usfHRAAE6OALhQbSjKCKYLL2b1Sztg3G2of6hR
04Zf0Ls5HPAzUKDXtcQPMrrHWqKDFTFKTBHcc9lKizGaLDNXdbnftNmU4JSmfDfyDOCjWoXn
WNE2FUonb+zYV2l5MwJ3jpxA9PHFcXvZu2nwDFpcFUMPzZ4UsRTzjpaCxoaj6WNB+tNBH1c7
TcPic4QTzaLUPJqFR4CULm+V/Y4ZDuxCfCybKsYhnuFPHyA4w2B3

/
CREATE OR REPLACE TYPE BODY kupc$_complete_imp_object wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
1b2 138
sw2+M+O4IfFitJ7kd83cFzprck0wg43I2ssVfC+iJscYYhZn5namovdXmZ4UmK+HmcyTZvKv
rhqp+AtJz6s2FZWXP+wtF1YF06ju9ZnGul6BTDKteLCSo5hzvlKcVWvi4i8T52d/iLMrvfZ1
ugnxf6+Xp+W7jh8BSqzR1fLG+tONdDSG+OCEP/Fi03eMTyeSDDvwNHcklYRQFiu2BEfBvAok
qxMMsXuv6WDNlAKTWs4K+th5O9Qso5gHEYN7V66QrypSpc5FpGxoND4AJqpe4KQJEvyGJN7n
bzNaKSEYFYpV+yM7D4w=

/
CREATE OR REPLACE TYPE BODY kupc$_api_ack wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
4eb 13c
zoxgzRFFac/eep1zEK0eyJZPp6Qwgz0JLcsVyi8yM9VIfQ70f/+rWxiAXm2Ax92Pol+3KSWV
tR/yhuB3lWtlyJjG2VWGQ77HbWnsaohFEqpiFWOdAtkNHTjBpiXIMopjgnSXt/UNqBHP1W3K
g3vnMVZmHk414Zuw0zrVx71f/4I36TtRqbSjZEynCeBc63wGkdWcoiD+1o6+HGNGCDh4S8it
4i4UGknTnfP7m6MXWt7MMTZ5wE/+sKspSxO1/zezrD2/0U5X+RGX7IlYX/YtdeXe8uqqyC1N
wMI++AzQD7Y6PAb1chwYYTa4

/
CREATE OR REPLACE TYPE BODY kupc$_mastererror wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
253 124
PDPXzfjRAYoSMd1WT9OKjX24Mvwwgz3IACgVyi9AkPjVSH0O9H//38tiRAljUHZ89SdfKZFf
OYG12YBbSTK49zdomXJV7b/ouxbD5bnu0lMcTu7PU1WAeHu/Umn8dKkWJrKj4I7hA/F1YKG0
BUpdhLonhPdmxW4Sm3MIBFlC2lwq8SbQPplnJ1byUMN8u9QMeQKhvMWX/YgMoOwTfJXJ/R63
PW1kOJJWZvqi+jKPPKGAFBEsGpx3fNvDPOkzajpYj6YlYZSVQ6pi2dq1n0zuQQD79OU3NA==


/
CREATE OR REPLACE TYPE BODY kupc$_masterjobinfo wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
266 124
+wATGIS3+Km39ZWSKskl3IuGdZUwgz1pACgVyi8yuWRTa9Yb1FcFV46eGvJr7gt9d02zovA8
zgi1AhUGUX9S9+6PuRnaGQDrdzbIVqtXItEToAA7SP7NgVA7/sFMW77cpkuOgxZt8MNnO93o
ieGnYdTeukODLw3ITY7Dy6QzcwgW43dakoWIN2bUxfvsuPw2vsO6SKwholQ+kvONydRkZRP+
Tghd6aP9BZPQY3oXg++wqNDKDwi/FkAPcxPjZgw//B1DR+k41aJ3zrtxx/ydpdfGr7Ym/EC3


/
CREATE OR REPLACE TYPE BODY kupc$_master_key_exchange wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
180 130
b4sP26D8wgx6OZh1CaflxRrBONwwgwLIJJkVfC+VkPg+SLhpL1uAlWsucgTYoaHR4LDKCY6i
87WpPxK36NbWtHTuAr+dhu1pXGaRxWSP0jS5+Lk0mCT8E9o9IOqdM8ZVQ2mEJ9Om6BqoeYg+
spnViL1sOAEMPL8edy8nxBWX7qdiXvpSj/S1sKBYWzS0GoOCI2X8osCvs1AfJaF0Ne+TYq9w
LaUA5Ou0rOCMdL7I1xgN7o75OHsgqy0I0GDipOxseZLmS3wvDrRsezfe1iNJ5X3bFjWMRxeh
07kZW89wVCo=

/
CREATE OR REPLACE TYPE BODY kupc$_mdFilePiece wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
31c 150
tyI+gCc+0CyIGL1l4jCfkc94VHgwgw3MmEoVfC8ai9VhDlcUnidR1dMS8Fbf9tnQrMXpWjeP
GvbOqm7Z6QfLmWYUcbSGMaTZ2rYzb2tlwCiw2b+YEbzL/DC5ii322hZzdmcEM6/p818dlJM2
eQSfsxjpXgxjvTtgN498osaP98MlYwrQjkAfxWgn3EmpXw15I/CnphOuVB+qoCq8xrXe5v+z
bPfz/qDMxbHXAfCdIYBRExi4FrvFalYAYKeVz8K9LCT8gAzeraZKMgJIgcN8RWWTfJIqk2nx
U5R6zQ+8bzLseiyfrDpTtkdbQT/kM4X4EJ9ERRjoTA==

/
CREATE OR REPLACE TYPE BODY kupc$_mdReplOffsets wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
164 f3
gk7kBgBc6jSUHxxIPjjbsmYcBq0wg5Cuf8sVfHSRudV69anwWBg3G8vlEZCFUkDcpA5MpiYJ
7rUa1xhnj6+8A7l+kKDLa6BFAh7HesFVcxVzMANqfIHQvcsiHWmnNLhp4IhZymyNbFdEsJvi
s1/iYdQwjihf03XdC3lRggksJ6F48norjkln03IRxAd5LYrxUtRaRYU/zr6H5E/FnrYOUImF
pT1LOu+AFLu3RxCB4XUaaTE=

/
CREATE OR REPLACE TYPE BODY kupc$_fileInfo wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
26b 185
37uG8XRFmhks0oguzZ+fBRTmYiMwg3nx7dxqfC+pWE6OeNL7cGzgpXKtAD0t709M86fL4/JN
lEul+bQuDIboiPHOmLv/wU9Xy+clHvPLnSS7ClX5Ts41D/ggL2imFrtXQBpRKHDxXvc01i6r
dycXhWathqhwWa/7jCqtPiitMVdjDIqFQ5ZnLUz8bEB6MD83xjNGEncU4N5rFbp0ccmsq/ae
VKOIcrRs9gX2QrPvaPClqSeIKdPeU3pcGh9ksCEjajrS1BhKF70XVtiBJ8DV2uoEepqDZdkT
Yzs8ZnzUJowx+RH1l/bATAJOHAu0UUq8FXq6UHRJYBBbDxhWfqhih82wte+ohJkSYlPBBGPt
O0y5ojqAsAXoPrsHJL/ArD0=

/
CREATE OR REPLACE TYPE BODY kupc$_file_list wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
110 f3
AGABOsBrZ2uNA5aOhVpHyfrTyWQwgxBKmMsVfHTpWPiUHHvdFVtpf1B3JmbmCZX/UD4d4SZR
HdOltV03lzYcViS5DSjQHeb2mPNIZPi+y7HevEZCI3ruZ5SpS0C0Qq88N9JgS8I5Sj8vMsjy
C1AYMKQynYQbocW84no6F4OphDP/pmun8xRhXSofGm8SAcL4ogBJ5FUiLB8FRD7PKy48YiSM
fIaJUjr3JyFMXlw+ZBkVuiQd

/
CREATE OR REPLACE TYPE BODY kupc$_encoded_pwd wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
15a 10f
/+uNBQNINSOk3idOuK1dzpTGWPYwg/DQ7cusfC+pkEIY/QQhfyKp1PuD1i/u8oP2415bcGXM
b4YeBQn1f6vaIf5OTLnaIsTnvvEXU2iwIjKGDZ2yho/oxqZYoaZGZmqDniurngys1em4wjta
pPFp02P22r4zXf7BNXJGWhdVMyigYOHCLkqSHzT78H4qN69FpWEiKmGLfZALk7N6VXXxao34
hopin1IHuvwHkTH4RWyp8zoRvsozSPgU08zv21o/Fr21/L0l3Nzf

/
CREATE OR REPLACE TYPE BODY kupc$_get_work wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
194 103
K9F7mXSCfDVllyqYXpid+TKyM3Awgw3QLcusfC9AkEIY/QT1f//fywnL5qnV3mSoWaTjUnBQ
BPBkILr1gvwGsu32u7W5uwhQqJHFLHBFkMZ3pCjqvyRMG7QTNmfFZdg7kWNrSxS+CTYNzZH8
8pGx1UzWYGHs3XBeMIUP8Hkw1IJW1ZuIDipsW7DN0QbAcxVVA+9R2JfW4O/mpCyL7mv0iW1d
xJZi75I+IyA2kQV0gerN/Cj9I6oIn5240RyYzUwm

/
CREATE OR REPLACE TYPE BODY kupc$_worker_file wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
687 1a5
a24xEbBQskCIE9YfF8ae2UCa2Eswg83Dr/Idfy+BaGSFa1tE9wDVHPF+wkbJt2y3aWGcdhrm
3jU+4527fmBjBwbCJ2Nb/kuRG7tsWP4b9BCwdaUycmGWcihO5JKgmuL+OlIDuoLLgtQavy+E
8bNb6Le3szDGbya3TjTSOGvmPNTlDKI/c2IuLh2co2sVgRZrHYLwDnmC8FAVJ6uoN3Vgj16/
UP8s02AI6lZNdawLDtjUzXxGke+TScMLaF/FeQZw0s0QLdwZdlScmkm7ntNM5i/s6ahpX4dp
2GIgcIUOtIne8IJ5J4J1XJMs6WP0NuX/UdBsbZfMp7oeQ0l1qqnZNU2LwkVOibD8QC3AMBoP
isZPn9mauk5MzQoLl+qAMmTcO5KIvOG1nCM0LeW2hynuqgg5A2UMTw==

/
CREATE OR REPLACE TYPE BODY kupc$_device_ident wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
1a6 12c
29OD37QeLMjrmVjjmPUJ5JDPpTwwg/DIJCisfC+VkDqOeHwR4HZ2bMtjdrTn6uskFFmkqTd1
BFuBTroWHbe0a0IQ7b/tDy7HhFoBPN1zc34LsYFPa81VUIHQH3yk+7ihgxbZ8MPIugZgWqwK
7Qi0AVSZStyRWskeDKpkNFasyrpjTTMe++WsTVgGH+hKtaJdm/A9kqQWISvzEVbHch7Qg6cb
yLBU5+yjw0V8hoCQ/7atJFb6Vc8TojfxlCNW0lMD7/L12+U+uVinuSEBpQGlanqMYJfxFqv+
1x81DFTG

/
CREATE OR REPLACE TYPE BODY kupc$_bad_file wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
151 10f
31lvTxyuUgwJjQ/qRCw1OWhkA4owgwLQ18sVyi9GAE6OEn01toYdtDAW9QUh6RGnbOhJBiDg
0o+V/h/y7cVbZXQDfCzQHayggefQ/h5xRusI00j+wZTFSaaJKkr61WE28HgY2vYO/tbFrNj8
UPWrnH8zEqjMb+2WrGFiq+hSc79Z8dfm3tW16OpnhUF0V3cuVizQ//b/BNMF/1muikzZ9DCY
E3x3i23zixMJR43vUnTp95CJ7xJah1an7eQLJRH8CeOgliI10oCY

/
CREATE OR REPLACE TYPE BODY kupc$_table_data_array wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
12b 103
VaNPaRBQPMVYhdVYGNm6lKTnYmAwgwKumMsVfHSRueowfaaZLGeVyBveXPPxxZ9A3MwwWXwO
5XTkAKFqaX+pW9nQTlVYQIfmedumxMGGcZI+brnqqr1epTh2apkEb6ZoERQeV4iZ8Otue4zu
jyOHI+AN8Yd84EGT2UAyRrXL03VtIOHkEkX71fqTshZctjuVb5BRfsKnebAXGO9hifmDzRey
vEx15IrliFNQ3I99VnID8uVjb1zMGjQjHTGI6QM=

/
CREATE OR REPLACE TYPE BODY kupc$_type_comp_ready wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
11a ff
THlm7BFHwcsS+oI7uRuPfBDJUZIwgwJKLcusZ3RnkDoYy3RFzvvTW62eqOYoZO03KeDI+gT0
szed/rm4wFD9I3lOgyIp2kZxHwBxD+vIRcF68EhTmhv+BHKciMtuphYuVtTFsznyDPInLrig
kPKQzkKw9QWt1gdRDxKS/gsYLDHfgE6cGak1LUCpLT7tX5Yx38IRQ1Q9juqgcUTztM2Mp4M/
3r4oyOnsCKJ7S1kMC77zwBpmDPEv6iDzzTWQ

/
CREATE OR REPLACE TYPE BODY kupc$_worker_log_entry wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
124 107
Gf607iNmxg31sqtA9w87dk+EGBQwgwLQncusZ3TUkEIYy3RFzqbTW62eqHDQaIHmdUh82/vv
QBFfILtzUsBQyy4T+bwz1Sik5tFt++jGzYmDwTRZhuCWTjFKsfibrNbcpkYU15fnp57yhKz2
oVB13BphnOU1AbqTkxQraoPunWprLRFZ/DI1M+oN+wJ+jjfUYfXicQou2bMPSlwuOJXM6ooP
g83WJC1zMxckom+lvLl6/Ogt0HjP8MORoQZO/LKfmKJy

/
CREATE OR REPLACE TYPE BODY kupc$_workererror wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
384 148
x5a0TtYf5to1YOK25Gk4CzTtui0wg1X3LZ7hf3RAkLs+ZVcW4ygOVzDtQW48wyWOUkU1bnaJ
rM6S6B/zSSiAzVDoqk4HP70sn2/yD6SPz5gcB81z8f+w9fIp8XCInqaGf3zpakEOShFTCOcT
U4Jqn7veC/rTQquhi8Fs3qtNv83ZOfYkKf6IXdHdU2Jigf1xj3lU7XTtOgvK2fcvrDINfNkq
osbyD4Nc1ky9Jvq+6gPpgHDoINLNTlKHeqFj6vFJrwz6jpPxXioNeFwrf3uw5bo5/z3C5crl
Hh/Hfi3sH51XnO1L+fjKAgiYrYsQpabXfZjv

/
CREATE OR REPLACE TYPE BODY kupc$_worker_exit wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
11a 103
nZeYHc5lVmXu5m8XGKarVUj85pcwgwLQ2ssVfHRAWBKeKKRw7qbKOexFXHff9HaAUD6EPfsy
plzKVyKhat02HFYkPwVPvnjnAtESdRzEqP5yHnrwAywPnNp2eTnKoMJZ3EsbTW7TVg2s1Ij3
+LfoOfqGk5t7FqoT9wGeiR6eGp2Ssi/C70RvBcUORndFp7bDNw3D2Rj/PHYPtKRvFi1zrJtP
iz/MqyXhO4EpP3bnWiaN0ZUEXBYBs2QZlLQ1HQ==

/
CREATE OR REPLACE TYPE BODY kupc$_worker_file_list wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
188 10f
qlD2a66bteTKQngblmABDS+EWJ4wgw1KJCisfC+VkDqOeHx94G5sywnLJWmjJYeEbnsEWecU
q3fOgXmv9FNXMGpzoRlzGYxe8MjlijZzTp9KVR57M8190VVQRWuYJI8RZqboGqh5iD6yvo1f
U/Fpg+yV4sxFos3A0VC9SOch8T3TdBhoJPjrVDWCG5WsDCT7xV5puBksG3QF0X+5jFobrXKs
wHgsAzW0zMmh0ro0MoaTJSs+/Neiune1JRKGuzqED+37PwuRkw==

/
CREATE OR REPLACE TYPE BODY kupc$_worker_get_pwd wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
17e 107
WRjKogwt3JmM2Uf2ozGe4CEVWOcwgw1KACisZ3RAkDqUpAT1f//TW77VRqYAwLGZUkU19B3W
RhHO+Bk3bdSVr8tzWgXBEDp3yhryQQ6qdMG0LsQtu2C/zblIddG4IfOpaZFUuq/yhMmhuGvn
8gXjtA3ynE1MSorsK6xgYezdcI066iSrugjhoX+Wheqpg112w/4HiGZhuy/+g0lOUqhqVUiI
b89995HTc+B5VSPTMXvp7ViTLAiWwYczmP7I6q6Lijii

/
CREATE OR REPLACE TYPE BODY kupc$_JobInfo wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
1e19 64e
xHPk+NVHkc2fKbTlN3gaZHKAtbAwg81UuiAF344ZAz9ELOFa23FqoUVhTRP7wqJJo2wlDk2f
P9On3QXCa5/uU2eZ0sbQiRb0iSa6fkkQdTei6PpOpEEFxoQtQ+E3iAicj5qWT7v/JZrfxK+S
crK4C5mm0I91s9sLRqxCrABvL3QZSZnQZO8DpnL0auoNqubApDkEN2daQWPAtD45++lWawTb
Fm5OVaU4bkZWmrF0TFtX1meJ1EcBJrSZMBJseMaNykcRqeCA/I5qY++NhFfXRseyBtoV+Xd7
8a90c/9GDSxx/FVT0uB3Pq/wyo5Js3TMqBadOhG5nm1S00ByhuIbO/J2kE73wvjMbkdTtclK
pa99z/V/WFnKejuYbVXFvafwT0cBAhVg1QIwj1w5I46+dACT+9752LoXo4bSVmYwou9PxBFK
zVGMlMt6SBykVBaAuF6TVuwB85esxA7bhD/m87gQnetYkECyLkDsNa92VycI0ADxcDkZ3l98
y9YWcHy2cHjnugHAKwwwWoKETj77us1XOXVd/UbAhzWzUtLXRkhHDo+M4QrdgDhfQIX29JkM
jopOkIuM/BL2NKIJT0pHRazvivpok0XCD1ccKWsVSSsodC4LxqOwmQq0jVxOfVIVTlkh5Kq4
/awKHARMFYgA3gcYBkKGOiWNgoinTlOOff9uAgxVfXHXYWV5fpiwzpU4BpwH9J16WeScatsP
pBv5knwIeLIGsAAXrur+cxQHKUIYI1uLrNCcCHV4Dyz/i35uO1rpQ9r84JOpm0KoT5ybOsIg
09mBZF1ODc+8N0uMEhb4tK1r99nlOQkpjzDl5/TgR9f+bJ1ZO5t99s4qru/6DHoGtn/6SKxT
rOoy9JNfIuxJ/WUbruDZI9smbDuUxyWuXJroWNkqu2s8Sj6+N9B4NeP1OGOdXbaRzDN15R8n
q3aU+4ulpyU0JxWGQmdjjXkQ2Ks+4v+mf2Kxp8mJ07Ir49CrLaNS5SNOcYWYAUMHT686oPtH
s8j+nj3DS6ufEjoRy7iOuu5T7qYsRq9bUWhr+pTUL3A1y8WibD7CWVdV9YJ9Wj1EsjC1aQxJ
pF7te+UcIHkuV9HJlyr1fOmgLWcXk+qIIOX2qm+VPqG0ZjgL+ZzJWDgDnbssJ5ZUeMS12Lmf
qbW8ktJC/tdAEiF8jvxIAxlzUp0/pt/O+aSJ+5EUlAeg7l8C4JDXr1NzE51QI8RzGy0cfhGL
dTww1QLPZtEnx1/JYIusFcCyRq6J4i32ItU20gYWEGOFoQHucyNjRYqA6PIDsanJ8lV5bCxN
PHjPfriBCjvM3LdgSBppYfmbKZ8NROpYK7JVBAcAGLbWNOg4rg0RmFV+KOsKUMcPO36BMhd3
M2q2MDeDR5rNH1pvouOM6W2MAyFP1zdt1ePHrX/+kbJoLomctvJzocPuD1iZNLczTEBgYbud
4+c/LXGD8Xgy7CoyGbHjY0K/2chPniCR8SA3AFx1UZawyzg9xtIwAl2mi+VSsXwzq4UPEJ7J
nenVh89XZcKsmkUeSDbO7RYSoWUNdGSWW7GPP5Q8Hi+g2xeuPXflnfgcw7yBVXdkEQa1rrX7
CFMz6A==

/
@?/rdbms/admin/sqlsessend.sql
